/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import javax.swing.ImageIcon;
import java.awt.Color;
import java.awt.Font;

/**
 * Interface for repository (resource) access, implemented by the generated
 * repository class.
 */
public interface G9Repository {

    /** The name and path to the default g9 icon */
    String DEFAULT_G9_ICON = "images/genova8.png";
    
    /**
     * @param name (missing javadoc)
     * @return the color
     */
    public Color getColor(String name);

    /**
     * @param name (missing javadoc)
     * @return the font
     */
    public Font getFont(String name);

    /**
     * @param name (missing javadoc)
     * @return the image
     */
    public ImageIcon getImage(String name);

    /**
     * @param imageName (missing javadoc)
     */
    public void setDefaultImage(String imageName);
    
}
