/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import no.g9.client.support.G9Document;

public class ComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    private G9Document documentModel;

    public ComboBoxRenderer(G9Document documentModel, int outputJustification) {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 2, 1, 1));
        this.setHorizontalAlignment(outputJustification);
        this.documentModel = documentModel;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setFont(list.getFont());
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            this.setText(value == null ? "" : this.format(value));
        }
        return this;
    }

    protected String format(Object value) {
        if (value == null) {
            return null;
        }
        String formatValue = null;
        Object actualValue = this.getDisplayValue(value);
        if (actualValue != null) {
            formatValue = actualValue.toString();
            if (this.documentModel != null) {
                this.documentModel.setValue(actualValue);
                formatValue = this.documentModel.getOutputText();
            }
        }
        return formatValue;
    }

    protected Object getDisplayValue(Object domainObject) {
        return domainObject;
    }

    public Object parse(String str) throws ParseException {
        return this.documentModel.parse(str);
    }
}

