/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import no.g9.client.component.G9ComboBox;
import no.g9.support.G9Enumerator;
import no.g9.support.TypeTool;

public class G9ComboBoxModel
extends DefaultComboBoxModel
implements Comparator<Object> {
    private boolean isSorted;
    private List<Object> objects;
    private G9ComboBox comboBox;

    public G9ComboBoxModel() {
        this.objects = new LinkedList<Object>();
    }

    public G9ComboBoxModel(Object[] items) {
        super(items);
        this.objects = Arrays.asList(items);
    }

    public G9ComboBoxModel(Vector<?> v) {
        super(v);
        this.objects = v;
    }

    @Override
    public void addElement(Object anObject) {
        if (!this.isSorted()) {
            super.addElement(anObject);
            this.objects.add(anObject);
        } else {
            Object elem;
            int pos;
            super.removeAllElements();
            for (pos = 0; pos < this.objects.size() && this.compare(elem = this.objects.get(pos), anObject) < 0; ++pos) {
            }
            this.objects.add(pos, anObject);
            for (int i = 0; i < this.objects.size(); ++i) {
                super.addElement(this.objects.get(i));
            }
        }
    }

    public void addElements(Collection<? extends Object> items) {
        if (!this.isSorted()) {
            for (Object object : items) {
                super.addElement(object);
                this.objects.add(object);
            }
        } else {
            super.removeAllElements();
            this.objects.addAll(items);
            Collections.sort(this.objects, this);
            Iterator<Object> it = this.objects.iterator();
            while (it.hasNext()) {
                super.addElement(it.next());
            }
        }
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(boolean isSorted) {
        this.isSorted = isSorted;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof G9Enumerator && o2 instanceof G9Enumerator) {
            String o1S = this.comboBox.format(o1);
            String o2S = this.comboBox.format(o2);
            return TypeTool.compareTo((Object)o1S, (Object)o2S);
        }
        if (o1 instanceof Comparable && o1.getClass() == o2.getClass()) {
            return TypeTool.compareTo((Object)o1, (Object)o2);
        }
        o1 = this.comboBox.getDisplayValue(o1);
        o2 = this.comboBox.getDisplayValue(o2);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable) {
            return TypeTool.compareTo((Object)o1, (Object)o2);
        }
        return 0;
    }

    void setComboBox(G9ComboBox comboBox) {
        this.comboBox = comboBox;
    }

    @Override
    public void removeAllElements() {
        if (this.objects.size() > 0) {
            this.objects.clear();
        }
        super.removeAllElements();
    }

    @Override
    public void removeElement(Object anObject) {
        this.objects.remove(anObject);
        super.removeElement(anObject);
    }

    @Override
    public void removeElementAt(int index) {
        this.objects.remove(index);
        super.removeElementAt(index);
    }
}

