/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import no.g9.client.component.G9Button;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.EnumeratorDocument;
import no.g9.client.support.G9Document;
import no.g9.client.support.G9FieldValue;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.TypeTool;

public class G9PasswordField
extends JPasswordField
implements G9ValueState,
G9FieldValue {
    private Object oldVal;
    private Object initialVal;
    private boolean editable = true;
    private boolean enabled = true;
    private boolean bugFix;
    private int outputJustification = 2;
    private int inputJustification = 2;
    private boolean selectAllOnFocus = false;
    protected EventListenerList vcListeners = new EventListenerList();

    public G9PasswordField() {
        this(null, null, 0);
    }

    public G9PasswordField(String text) {
        this(null, text, 0);
    }

    public G9PasswordField(int columns) {
        this(null, null, columns);
    }

    public G9PasswordField(String text, int columns) {
        this(null, text, columns);
    }

    public G9PasswordField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((G9Document)G9PasswordField.this.getDocument()).setInputMode(true);
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                G9PasswordField.this.oldVal = G9PasswordField.this.getValue();
                G9PasswordField.this.setHorizontalAlignment(G9PasswordField.this.inputJustification);
                if (G9PasswordField.this.selectAllOnFocus) {
                    G9PasswordField.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                Object value = G9PasswordField.this.getValue();
                if (G9PasswordField.this.oldVal != null ^ value != null || G9PasswordField.this.oldVal != null && !G9PasswordField.this.oldVal.equals(value)) {
                    G9PasswordField.this.fireG9ValueChangedEvent(2000, G9PasswordField.this.oldVal, value);
                }
                ((G9Document)G9PasswordField.this.getDocument()).setInputMode(false);
                G9PasswordField.this.setHorizontalAlignment(G9PasswordField.this.outputJustification);
                G9PasswordField.this.setCaretPosition(0);
            }

            private boolean menuOrToolbar(Component opposite) {
                return opposite == null || opposite instanceof JRootPane || opposite instanceof G9Button && ((G9Button)opposite).isInToolbar();
            }
        });
        super.setEditable(true);
        super.setEnabled(true);
        this.editable = true;
        this.enabled = true;
        this.bugFix = TypeTool.isVmVersion1_4();
    }

    @Override
    public void resetState() {
        this.initialVal = this.oldVal = this.getValue();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!this.bugFix) {
            return;
        }
        this.enabled = enable;
        if (!enable || this.editable) {
            super.setEditable(enable);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        super.setEditable(editable);
        this.setEnabled(this.enabled);
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    @Override
    public boolean isChanged() {
        if (this.initialVal == null) {
            return this.getValue() != null;
        }
        if (this.getValue() == null) {
            return true;
        }
        return !this.getValue().equals(this.initialVal);
    }

    @Override
    public void display(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && value instanceof String) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.setValue(value);
    }

    @Override
    public void setText(String s) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument) {
            this.setValue(((EnumeratorDocument)doc).toValue(s));
        } else {
            super.setText(s);
        }
    }

    @Override
    public Object getInitialValue() {
        return this.initialVal;
    }

    @Override
    public void setInitialValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && (value instanceof String || value instanceof Integer)) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.oldVal = this.initialVal = value;
    }

    public void setInputJustification(int justification) {
        this.inputJustification = justification;
    }

    public void setOutputJustification(int justification) {
        this.outputJustification = justification;
    }

    @Override
    public void setValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            ((G9Document)doc).setValue(value);
        } else {
            this.setText(value.toString());
        }
        this.setCaretPosition(0);
    }

    @Override
    public Object getValue() {
        Object value = null;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            value = gDoc.getValue();
        } else {
            value = this.getPassword();
        }
        return value;
    }

    @Override
    public String format() {
        String str = "";
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            str = gDoc.format();
        }
        return str;
    }

    @Override
    public Object parse(String formattedString) {
        Object o = null;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            try {
                o = gDoc.parse(formattedString);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{this.getClass(), this.getName(), formattedString};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1514", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)e, msg);
            }
        }
        return o;
    }

    public Object parse(Object o) {
        return o;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }
}

