/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component.menu;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import no.g9.client.component.menu.G9EditMenu;
import no.g9.client.component.menu.G9Menu;
import no.g9.client.support.G9DialogFrame;

public class G9MenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private G9Menu fileMenu;
    private G9Menu editMenu;
    private G9Menu viewMenu;
    private G9Menu windowMenu;
    private G9Menu helpMenu;
    private Map<String, Component> customNameToMenu = new HashMap<String, Component>();
    private List<Component> myComponents;
    private G9DialogFrame parentFrame;
    private boolean isModal = false;

    public G9MenuBar(G9DialogFrame parentFrame) {
        if (parentFrame == null) {
            throw new IllegalArgumentException("Parent frame can not be null");
        }
        this.parentFrame = parentFrame;
    }

    public synchronized JMenu addG9Menu(JMenu menu) {
        return this.add(menu);
    }

    public G9DialogFrame getParentFrame() {
        return this.parentFrame;
    }

    @Override
    public synchronized JMenu add(JMenu c) {
        if (c instanceof G9Menu) {
            G9Menu menu = (G9Menu)c;
            switch (menu.getMenuType()) {
                case 0: {
                    if (this.customNameToMenu.containsKey(c.getName())) break;
                    this.customNameToMenu.put(c.getName(), c);
                    break;
                }
                case 1: {
                    this.fileMenu = menu;
                    break;
                }
                case 2: {
                    this.editMenu = menu;
                    break;
                }
                case 3: {
                    this.viewMenu = menu;
                    break;
                }
                case 4: {
                    this.windowMenu = menu;
                    break;
                }
                case 5: {
                    this.helpMenu = menu;
                    break;
                }
            }
        }
        if (this.myComponents == null) {
            this.myComponents = new ArrayList<Component>();
        }
        this.myComponents.add(c);
        return super.add(c);
    }

    public synchronized void mergeMenues(G9DialogFrame dialog) {
        Component[] menuComps = null;
        if (dialog != null && dialog.getG9MenuBar() != null) {
            menuComps = dialog.getG9MenuBar().getG9Components();
        }
        this.mergeMenues(menuComps, dialog != null ? dialog.isModal() : false);
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void mergeMenues(Component[] menues, boolean modal) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i;
            int mergePos;
            this.removeAll();
            Component[] my = this.getG9Components();
            int n = mergePos = this.myComponents != null ? this.myComponents.size() : 0;
            if (this.windowMenu != null) {
                mergePos = this.myComponents.indexOf(this.windowMenu);
            } else if (this.helpMenu != null) {
                mergePos = this.myComponents.indexOf(this.helpMenu);
            }
            for (int i2 = 0; i2 < mergePos; ++i2) {
                this.add(my[i2]);
            }
            HashSet<G9Menu> mergedMenus = new HashSet<G9Menu>();
            if (menues != null) {
                for (i = 0; i < menues.length; ++i) {
                    if (menues[i] instanceof G9Menu) {
                        G9Menu gm = (G9Menu)menues[i];
                        boolean merged = false;
                        switch (gm.getMenuType()) {
                            case 0: {
                                G9Menu custom = (G9Menu)this.customNameToMenu.get(gm.getName());
                                if (custom == null) break;
                                custom.setText(gm.getText());
                                custom.mergeMenu(gm);
                                mergedMenus.add(custom);
                                merged = true;
                                break;
                            }
                            case 1: {
                                if (this.fileMenu == null) break;
                                this.fileMenu.setText(gm.getText());
                                this.fileMenu.mergeMenu(gm);
                                mergedMenus.add(this.fileMenu);
                                merged = true;
                                break;
                            }
                            case 2: {
                                if (this.editMenu == null) break;
                                this.editMenu.setText(gm.getText());
                                this.editMenu.mergeMenu(gm);
                                mergedMenus.add(this.editMenu);
                                merged = true;
                                break;
                            }
                            case 3: {
                                if (this.viewMenu == null) break;
                                this.viewMenu.setText(gm.getText());
                                this.viewMenu.mergeMenu(gm);
                                mergedMenus.add(this.viewMenu);
                                merged = true;
                                break;
                            }
                            case 4: {
                                if (this.windowMenu == null) break;
                                this.windowMenu.setText(gm.getText());
                                this.windowMenu.mergeMenu(gm);
                                mergedMenus.add(this.windowMenu);
                                merged = true;
                                break;
                            }
                            case 5: {
                                if (this.helpMenu == null) break;
                                this.helpMenu.setText(gm.getText());
                                this.helpMenu.mergeMenu(gm);
                                mergedMenus.add(this.helpMenu);
                                merged = true;
                                break;
                            }
                        }
                        if (merged) continue;
                        this.add(menues[i]);
                        continue;
                    }
                    this.add(menues[i]);
                }
            }
            if (my != null) {
                for (i = mergePos; i < my.length; ++i) {
                    this.add(my[i]);
                }
                for (i = 0; i < my.length; ++i) {
                    if (mergedMenus.contains(my[i])) continue;
                    ((G9Menu)my[i]).mergeMenu(null);
                }
            }
            this.setModal(modal);
        }
    }

    public synchronized void setEnabledWholeMenuBar(boolean enable) {
        if (this.myComponents == null) {
            return;
        }
        for (Component menu : this.myComponents) {
            if (!(menu instanceof G9Menu)) continue;
            ((G9Menu)menu).setEnabledWholeMenu(enable);
        }
    }

    public synchronized void setModal(boolean isModal) {
        if (isModal == this.isModal) {
            return;
        }
        this.isModal = isModal;
        if (this.myComponents == null) {
            return;
        }
        for (Component menu : this.myComponents) {
            if (!(menu instanceof G9Menu)) continue;
            ((G9Menu)menu).setModal(isModal);
        }
    }

    public synchronized boolean isModal() {
        return this.isModal;
    }

    public synchronized void setRemoveConsecutiveSeparators(boolean remove) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            if (!(this.getMenu(i) instanceof G9Menu)) continue;
            ((G9Menu)this.getMenu(i)).setRemoveConsecutiveSeparators(remove);
        }
    }

    public synchronized Component[] getG9Components() {
        if (this.myComponents == null) {
            return null;
        }
        Component[] retVal = new Component[this.myComponents.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.myComponents.get(i);
        }
        return retVal;
    }

    public synchronized G9Menu getMenu(int menuType, String customName) {
        G9Menu menu = null;
        switch (menuType) {
            case 0: {
                menu = (G9Menu)this.customNameToMenu.get(customName);
                break;
            }
            case 1: {
                menu = this.fileMenu;
                break;
            }
            case 2: {
                menu = this.editMenu;
                break;
            }
            case 3: {
                menu = this.viewMenu;
                break;
            }
            case 4: {
                menu = this.windowMenu;
                break;
            }
            case 5: {
                menu = this.helpMenu;
                break;
            }
        }
        return menu;
    }

    public synchronized void toggleEditMenu(boolean enable) {
        G9EditMenu menu = (G9EditMenu)this.getMenu(2, null);
        if (menu != null) {
            menu.toggleEditComponents(enable);
        }
    }
}

