/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import no.g9.client.support.CellRenderOverride;
import no.g9.client.support.G9Document;
import no.g9.client.support.G9Table;

public class G9TableCellRenderer
extends DefaultTableCellRenderer {
    private G9Document document;

    public G9TableCellRenderer(G9Document document, int justification) {
        this.document = document;
        this.setHorizontalAlignment(justification);
    }

    @Override
    protected void setValue(Object value) {
        if (value instanceof String) {
            try {
                value = this.document.parse((String)value);
            }
            catch (ParseException e) {
                value = null;
            }
        }
        this.document.setValue(value);
        this.setText(this.document.getOutputText());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        rendererComponent.setEnabled(this.isEnabled());
        if (table instanceof G9Table) {
            CellRenderOverride cro;
            G9Table gt = (G9Table)table;
            boolean isChanged = gt.isChanged(row);
            if (isSelected) {
                if (!hasFocus) {
                    rendererComponent.setForeground(table.getSelectionForeground());
                }
            } else if (isChanged) {
                rendererComponent.setForeground(gt.getChangedForgroundColor());
            } else {
                rendererComponent.setForeground(table.getForeground());
            }
            if ((cro = gt.getRenderOverride()) != null) {
                rendererComponent = cro.getTableCellRendererComponent(rendererComponent, gt.getListblock().getLine(row), value, isSelected, hasFocus, row, column);
            }
        }
        return rendererComponent;
    }
}

