/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.CustomDate;

public class LocalDateTimeDocument
extends G9Document {
    public LocalDateTimeDocument(int datatype, String inputFormat, String outputFormat, int maxLength) {
        super(datatype, inputFormat, outputFormat, maxLength);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (!this.getInputMode()) {
            super.insertString(offset, str, attr);
            return;
        }
        String format = this.getInputFormat();
        if (str.length() + this.getLength() > format.length()) {
            return;
        }
        char aChar = str.charAt(0);
        char fChar = format.charAt(offset);
        if (Character.isDigit(aChar) == Character.isLetter(fChar) && (Character.isLetterOrDigit(fChar) || !Character.isLetterOrDigit(aChar))) {
            char bChar;
            super.insertString(offset, str, attr);
            if (!(++offset >= format.length() || Character.isLetterOrDigit(bChar = format.charAt(offset)) || this.getLength() != offset && this.getText(offset, 1).charAt(0) == bChar)) {
                super.insertString(offset, "" + bChar, attr);
            }
        }
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.stringToDate(this.dateToString((LocalDateTime)o));
    }

    @Override
    public synchronized void setValue(Object value) {
        String buf = null;
        super.setValue(value);
        if (value != null) {
            LocalDateTime ld = (LocalDateTime)value;
            buf = ld.format(DateTimeFormatter.ofPattern(this.getFormat()));
        }
        try {
            this.replace(0, this.getLength(), buf, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(LocalDateTimeDocument.class).warn((Object)"Failed to set value.", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result;
        block6: {
            result = super.getValue();
            if (this.getInputMode()) {
                String strValue = null;
                try {
                    strValue = this.getText(0, this.getLength());
                }
                catch (BadLocationException e) {
                    Logger.getLogger(LocalDateTimeDocument.class).warn((Object)"Failed to get value.", (Throwable)e);
                }
                if (strValue != null && (strValue.length() != 0 || result != null)) {
                    try {
                        result = LocalDateTime.parse(strValue, DateTimeFormatter.ofPattern(this.getFormat()));
                    }
                    catch (DateTimeParseException e) {
                        if (strValue.length() != 0) break block6;
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized String format() {
        String str = "";
        LocalDateTime ld = (LocalDateTime)this.getValue();
        if (ld != null) {
            str = ld.format(DateTimeFormatter.ofPattern(this.getInternalFormat()));
        }
        return str;
    }

    @Override
    public synchronized Object parse(String str) throws DateTimeParseException {
        LocalDateTime value = null;
        if (str != null && str.length() != 0) {
            value = LocalDateTime.parse(str, DateTimeFormatter.ofPattern(this.getInternalFormat()));
        }
        return value;
    }

    @Override
    public synchronized String getOutputText() {
        return this.getValue() != null ? ((LocalDateTime)this.getValue()).format(DateTimeFormatter.ofPattern(this.getOutputFormat())) : null;
    }

    private String dateToString(LocalDateTime date) {
        if (date != null) {
            try {
                return date.format(DateTimeFormatter.ofPattern(this.getFormat()));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return "";
    }

    private LocalDateTime stringToDate(String str) {
        if (str != null && !str.isEmpty()) {
            return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(this.getFormat()));
        }
        return null;
    }

    private String getFormat() {
        return this.getInputMode() ? this.getInputFormat() : this.getOutputFormat();
    }

    private String getInternalFormat() {
        return CustomDate.getDatetimeInternalFormat((int)this.getDatatype());
    }
}

