/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class StatusBar
extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private JPanel leftPane = new JPanel();
    private JPanel rightPane = new JPanel();
    private Font msgFont = null;

    public StatusBar() {
        BoxLayout rightToLeft = new BoxLayout(this.leftPane, 2);
        this.leftPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.leftPane.setLayout(rightToLeft);
        BoxLayout leftToRight = new BoxLayout(this.rightPane, 2);
        this.rightPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.rightPane.setLayout(leftToRight);
        BoxLayout sLayout = new BoxLayout(this, 2);
        this.setLayout(sLayout);
        Border border = BorderFactory.createRaisedBevelBorder();
        this.setBorder(border);
        super.add(this.leftPane);
        super.add(Box.createHorizontalGlue());
        super.add(new JLabel(" "));
        super.add(Box.createHorizontalGlue());
        super.add(this.rightPane);
    }

    @Override
    public Component add(Component component) {
        this.addComponent(component, 0, 0, false);
        return component;
    }

    public Component add(String msg) {
        return this.addComponent(this.getLabel(msg), 0, 0, false);
    }

    public Component addComponent(Component component, int ALIGNMENT) {
        return this.addComponent(component, ALIGNMENT, 0, false);
    }

    public Component addComponent(final Component component, int ALIGNMENT, final int timer, boolean bell) {
        switch (ALIGNMENT) {
            case 0: {
                this.leftPane.add(component);
                break;
            }
            case 1: {
                this.rightPane.add(component);
                break;
            }
            default: {
                throw new IllegalArgumentException("Alignment must be either LEFT or RIGHT");
            }
        }
        this.refreshStatusBar(bell);
        if (timer > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timer);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    StatusBar.this.removeComponent(component);
                }
            }).start();
        }
        return component;
    }

    public Component addTextLeft(String msg) {
        return this.addComponent(this.getLabel(msg), 0, 0, false);
    }

    public Component addTextRight(String msg) {
        return this.addComponent(this.getLabel(msg), 1, 0, false);
    }

    public Component addTextLeft(String msg, int timer, boolean bell) {
        return this.addComponent(this.getLabel(msg), 0, timer, bell);
    }

    public Component addTextRight(String msg, int timer, boolean bell) {
        return this.addComponent(this.getLabel(msg), 1, timer, bell);
    }

    public void setMessageFont(Font font) {
        this.msgFont = font;
    }

    public void removeComponent(Component component) {
        this.leftPane.remove(component);
        this.rightPane.remove(component);
        this.refreshStatusBar(false);
    }

    public void removeMessage(String msg) {
        JLabel l = this.identifyLabel(msg);
        if (l != null) {
            this.removeComponent(l);
        }
    }

    private void refreshStatusBar(final boolean bell) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.invalidate();
                StatusBar.this.validate();
                StatusBar.this.repaint();
                if (bell) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
    }

    private JLabel getLabel(String msg) {
        JLabel label = new JLabel(msg);
        if (this.msgFont != null) {
            label.setFont(this.msgFont);
        }
        return label;
    }

    private JLabel identifyLabel(String msg) {
        int leftCount = this.leftPane.getComponentCount();
        for (int i = 0; i < leftCount; ++i) {
            JLabel label;
            Component c = this.leftPane.getComponent(i);
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(msg)) continue;
            return label;
        }
        int rightCount = this.rightPane.getComponentCount();
        for (int i = 0; i < rightCount; ++i) {
            JLabel label;
            Component c = this.rightPane.getComponent(i);
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(msg)) continue;
            return label;
        }
        return null;
    }
}

