/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support.message;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import no.g9.client.support.ApplicationMethods;
import no.g9.client.support.G9DialogController;
import no.g9.client.support.message.ClientDispatcherContext;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageInteractor;
import no.g9.message.MessageReply;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageType;
import no.g9.message.MessageTypeEnum;
import no.g9.message.ReplySetType;

public class ClientInteractor
implements MessageInteractor {
    private ApplicationMethods application;

    public ClientInteractor() {
    }

    public ClientInteractor(ApplicationMethods application) {
        this.setApplication(application);
    }

    public MessageReply interact(final Message msg, final DispatcherContext context) {
        if (msg == null) {
            throw new IllegalArgumentException("Message cannot be a null pointer");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        ClientDispatcherContext clientCtx = (ClientDispatcherContext)context;
        if (clientCtx.getOwner() == null) {
            throw new IllegalArgumentException("Owner must be a Component");
        }
        Component owner = clientCtx.getOwner();
        this.setApplication(clientCtx.getApplication());
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ClientInteractor.this.interact(msg, context);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            return msg.getReply();
        }
        MessageType msgType = msg.getMsgType();
        if (msgType.equals(MessageTypeEnum.QUESTION)) {
            this.resolveDialogAction(msg, 3, MessageReplyType.REPLY_OK, owner);
        } else if (msgType.equals(MessageTypeEnum.QWARN)) {
            this.resolveDialogAction(msg, 2, MessageReplyType.REPLY_OK, owner);
        } else if (msgType.equals(MessageTypeEnum.INFO)) {
            this.resolveDialogAction(msg, 1, MessageReplyType.REPLY_OK, ReplySetType.REPLSET_OK, owner);
        } else if (msgType.equals(MessageTypeEnum.ERROR)) {
            this.resolveDialogAction(msg, 0, MessageReplyType.REPLY_OK, ReplySetType.REPLSET_OK, owner);
        } else if (msgType.equals(MessageTypeEnum.STATUS)) {
            this.showOnStatusBar(msg);
        } else if (msgType.equals(MessageTypeEnum.PROGRESS)) {
            this.showOnStatusBar(msg);
        }
        return msg.getReply();
    }

    private void showOnStatusBar(Message msg) {
        this.application.getStatusBar().add(msg.getHint());
        msg.setReply(MessageReplyType.REPLY_NONE);
    }

    private void resolveDialogAction(Message msg, int msgType, MessageReplyType standardOption, Component owner) {
        if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_NONE)) {
            return;
        }
        if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_ABORTRETRYIGNORE) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_OK) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_OKCANCEL) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_OKINFO) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_YESNO) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_YESNOCANCEL)) {
            this.showSimpleDialog(msg, msgType, standardOption, false, owner);
        } else if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_STRING)) {
            this.showSimpleDialog(msg, msgType, standardOption, true, owner);
        } else if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_DIR) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_DIR_EXISTS) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_FILE) || msg.getValidReplies().equals((Object)ReplySetType.REPLSET_FILE_EXISTS)) {
            this.showFileChooserDialog(msg);
        }
    }

    private void resolveDialogAction(Message msg, int msgType, MessageReplyType standardOption, ReplySetType replySet, Component owner) {
        ReplySetType originalReplySet = msg.getValidReplies();
        msg.setValidReplies(replySet);
        this.resolveDialogAction(msg, msgType, standardOption, owner);
        msg.setValidReplies(originalReplySet);
    }

    private void showSimpleDialog(Message msg, int msgType, MessageReplyType standardOption, boolean wantsInput, Component owner) {
        Object replyString;
        Object[] replySet = msg.getValidReplies().toReplySet();
        MessageReplyType defaultReply = Arrays.asList(replySet).contains(standardOption) ? standardOption : replySet[0];
        JOptionPane pane = new JOptionPane(msg.getMessageText(), msgType, -1, null, replySet, defaultReply);
        JDialog dialog = null;
        dialog = owner != null ? pane.createDialog(owner, this.getTitle(msg)) : (this.application != null ? pane.createDialog(this.application.getApplicationWindow(), this.getTitle(msg)) : pane.createDialog(null, this.getTitle(msg)));
        pane.setWantsInput(wantsInput);
        dialog.setVisible(true);
        dialog.dispose();
        Object reply = pane.getValue();
        if (reply == null || !(reply instanceof MessageReplyType)) {
            msg.setReply(MessageReplyType.REPLY_NONE);
        } else {
            msg.setReply((MessageReplyType)reply);
        }
        if (wantsInput && (replyString = pane.getInputValue()) != JOptionPane.UNINITIALIZED_VALUE) {
            msg.setReplString((String)replyString);
        }
    }

    private void showFileChooserDialog(Message msg) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(this.getTitle(msg));
        if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_DIR)) {
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogType(1);
        } else if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_DIR_EXISTS)) {
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogType(0);
        } else if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_FILE)) {
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogType(1);
        } else if (msg.getValidReplies().equals((Object)ReplySetType.REPLSET_FILE_EXISTS)) {
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogType(0);
        }
        String buttonTextPrefix = "Save ";
        String buttonText = msg.getTitle().equals("") ? "Save" : buttonTextPrefix + msg.getTitle();
        int reply = fileChooser.showDialog(this.getParentComponent(), buttonText);
        if (reply == -1) {
            msg.setReply(MessageReplyType.REPLY_NONE);
        } else if (reply == 1) {
            msg.setReply(MessageReplyType.REPLY_CANCEL);
        } else if (reply == 0) {
            msg.setReply(MessageReplyType.REPLY_OK);
            msg.setReplString(fileChooser.getSelectedFile().toString());
            msg.setReplyFile(fileChooser.getSelectedFile());
        }
    }

    private String getTitle(Message msg) {
        String title = msg.getTitle();
        if (title != null && title.trim().length() != 0) {
            return title;
        }
        if (this.application != null && this.application.getApplicationWindow() != null) {
            return this.application.getApplicationWindow().getTitle();
        }
        return "";
    }

    private Component getParentComponent() {
        if (this.application == null) {
            return null;
        }
        G9DialogController gdc = this.application.getActiveInternalWindow();
        Container activeWindow = gdc == null ? null : gdc.getWindow();
        return activeWindow == null ? this.application.getApplicationWindow() : activeWindow;
    }

    public ApplicationMethods getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationMethods application) {
        this.application = application;
    }
}

