/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;
import javax.swing.event.ListSelectionEvent;

/** Wraps a list selection event */
public class G9ListSelectionEventHolder extends G9Event {
    
    /** The wrapped event */
    ListSelectionEvent event;
    
    /** 
     * Constructs a new G9ListSelectionEventHolder
     * @param e the event to wrap.
     */
    public G9ListSelectionEventHolder(ListSelectionEvent e) {
        event = e;
    }
    
    /** 
     * Returns the wrapped ListSelectionEvent.
     * @return the wrapped event.
     */
    public ListSelectionEvent getEvent() {
        return event;
    }
}
