/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/**
 * Class representing a selection event. Each time a selection event occurs, an 
 * instance of this class will be created and sent as argument to the registered listeners.
 */
public class G9SelectedEvent extends G9Event {

    private int oldSelection;
    private int newSelection;
    
    /**
     * Creates a new G9SelectedEvent 
     * @param source the source of the event
     * @param oldSelection the index of the old selection
     * @param newSelection the index of the new selection
     */
    public G9SelectedEvent(Object source, int oldSelection, int newSelection) {
        super(source, 0);
        this.oldSelection = oldSelection;
        this.newSelection = newSelection;
    }

    /**
     * @return Returns the newSelection which will be selected if not
     * vetoed.
     */
    public int getNewSelection()  {
        return newSelection;
    }

    /**
     * @return Returns the oldSelection, which is the current selection.
     */
    public int getOldSelection() {
        return oldSelection;
    }
    
}
    

