/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.text.ParseException;

/**
 * Interface for value handling in text fields
 */
public interface G9FieldValue {

    /**
     * @param value (missing javadoc)
     */
    public void setValue(Object value);

    /**
     * @return (missing javadoc)
     */
    public Object getValue();

    /**
     * @return the formatted value according to the internal format.
     */
    public String format();

    /**
     * Returns a value object. The specified string must be a representation of
     * a value in the internal format.
     * 
     * @param str (missing javadoc)
     * @return (missing javadoc)
     * @throws ParseException (missing javadoc)
     */
    public Object parse(String str) throws ParseException;

}
