/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.util.HashMap;
import java.util.Map;

import javax.swing.KeyStroke;

/**
 * Helper class. Translates a g9 specified key stroke to the corresponding
 * java KeyStroke.
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public abstract class G9Render {
    
    private static Map g9ToKeyStroke = new HashMap();
    
    // initializes the map from g9 to java name.
    static {
        g9ToKeyStroke.put("ctrl", "control");
        g9ToKeyStroke.put("control", "control");
        g9ToKeyStroke.put("alt", "alt");
        g9ToKeyStroke.put("altgr", "alt");
        g9ToKeyStroke.put("shift", "shift");
        g9ToKeyStroke.put("meta", "meta");
        g9ToKeyStroke.put("del", "DELETE");
        g9ToKeyStroke.put("esc", "ESCAPE");
        g9ToKeyStroke.put("space", "SPACE");
        g9ToKeyStroke.put("pgup", "PAGE_UP");
        g9ToKeyStroke.put("pgdown", "PAGE_DOWN");
        g9ToKeyStroke.put("backspace", "BACK_SPACE");
        g9ToKeyStroke.put("return", "ENTER");
        g9ToKeyStroke.put("scrolllock", "SCROLL_LOCK");
        g9ToKeyStroke.put("ins", "INSERT");
        g9ToKeyStroke.put("capslock", "CAPS_LOCK");
    }

    /**
     * Translates a string of g9-style key strokes to a Java KeyStroke.
     * 
     * @param keyStrokePattern the g9-style key stroke.
     * @return a KeyStroke representing the specified key strokes.
     */
    public static KeyStroke render(String keyStrokePattern) {
        
        String pattern = "";
        
        String[] arr = keyStrokePattern.split("\\+");
        for (int i = 0; i < arr.length; i++) {
            if (g9ToKeyStroke.keySet().contains(arr[i].trim().toLowerCase())) {
                pattern += g9ToKeyStroke.get(arr[i].trim().toLowerCase()) + " ";
            } else {
                pattern += arr[i].trim().toUpperCase() + " ";
            }
        }
        
        pattern = pattern.trim();
        return KeyStroke.getKeyStroke(pattern);
        
    }

}
