/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.*;

/**
 * The Shell Launcher launches the specified file as a command on the Windows cmd shell.
 */
public class ShellLauncher implements Launcher {

    /**
     * @roseuid 4381B2600312
     */
    public ShellLauncher() {
        super();
    }

    /**
     * Launches the associated application to open the given file.
     *
     * @param file
     *            the given file.
     * @roseuid 437DDBA400E6
     * @deprecated Use {@link #open(File)}.
     */
    @Deprecated
    public void openLocal(File file) {
        open(file);
    }

    /**
     *
     * This Launcher does <em>not</em> support opening an URL. Invoking this
     * method will throw an {@linkplain UnsupportedOperationException}.
     * @param url The url to open
     *
     * @throws UnsupportedOperationException
     *             this operation is not supported by this launcher.
     * @deprecated Use {@link #open(URL)}.
     */
    @Deprecated
    public void openRemote(URL url) {
        open(url);
    }

    @Override
    public void open(File file) {
        Object[] args = null;
        Exception ex = null;
        try {
            Runtime.getRuntime().exec(
                    "cmd /c\"" + file.getCanonicalPath() + "\"");
        } catch (NullPointerException e) {
            args = new Object[]{"", e.getMessage()};
            ex = e;
        } catch (IOException e) {
            args = new Object[]{ file.toString(), e.getMessage() };
            ex = e;
        } finally {
            if (args != null) {
                Message msg = MessageSystem.getMessageFactory().getMessage(
                        CRuntimeMsg.FL_OPEN_LOCAL_FILE_ERROR, args);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(ex, msg);

            }
        }
    }

    /**
     * This Launcher does <em>not</em> support opening an URL. Invoking this
     * method will throw an {@linkplain UnsupportedOperationException}.
     *
     * @throws UnsupportedOperationException
     *             this operation is not supported by this launcher.
     */
    @Override
    public void open(URL url) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(
                "The shell launcher implementation does not support opening an URL.");

    }

}
