/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import no.esito.log.Logger;
import no.g9.client.support.Launcher;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class DesktopLauncher
implements Launcher {
    private static Logger log = Logger.getLogger(Launcher.class);

    @Override
    public void open(File file) {
        Exception exception = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening file: " + file));
            }
            Desktop.getDesktop().open(file);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        catch (UnsupportedOperationException e) {
            exception = e;
        }
        if (exception != null) {
            log.warn((Object)"Caught exception while opening file.", (Throwable)exception);
            Object[] args = new Object[]{file != null ? file.toString() : "", exception.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1401", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException((Throwable)exception, msg);
        }
    }

    @Override
    public void open(URL url) {
        Exception exception = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening url: " + url));
            }
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (UnsupportedOperationException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        if (exception != null) {
            log.warn((Object)"Caught exception while opening url.", (Throwable)exception);
            Object[] args = new Object[]{url != null ? url.toString() : "", exception.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1402", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException((Throwable)exception, msg);
        }
    }
}

