/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class DialogBoxTool {
    public static void showDialog(final JDialog dialog) {
        if (dialog.isVisible()) {
            dialog.toFront();
            return;
        }
        DialogAdapter adapter = DialogBoxTool.getAdapter(dialog);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        adapter.waitForWindowToOpen();
        adapter.waitForWindowToShow();
    }

    private static DialogAdapter getAdapter(JDialog dialog) {
        DialogAdapter adapter = null;
        WindowListener[] listeners = dialog.getWindowListeners();
        for (int i = 0; i < listeners.length; ++i) {
            WindowListener foo = listeners[i];
            if (!(foo instanceof DialogAdapter)) continue;
            adapter = (DialogAdapter)foo;
            break;
        }
        if (adapter == null) {
            adapter = new DialogAdapter();
            dialog.addWindowListener(adapter);
        }
        return adapter;
    }

    private static class DialogAdapter
    extends WindowAdapter {
        private boolean windowOpened;
        private boolean windowShown;

        private DialogAdapter() {
        }

        private synchronized void waitForWindowToOpen() {
            boolean interrupted = false;
            try {
                while (!this.windowOpened) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void waitForWindowToShow() {
            boolean interrupted = false;
            try {
                while (!this.windowShown) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowOpened(WindowEvent e) {
            DialogAdapter dialogAdapter = this;
            synchronized (dialogAdapter) {
                this.windowOpened = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent e) {
            DialogAdapter dialogAdapter = this;
            synchronized (dialogAdapter) {
                this.windowOpened = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowActivated(WindowEvent e) {
            DialogAdapter dialogAdapter = this;
            synchronized (dialogAdapter) {
                this.windowShown = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowDeactivated(WindowEvent e) {
            DialogAdapter dialogAdapter = this;
            synchronized (dialogAdapter) {
                if (!((JDialog)e.getSource()).isVisible()) {
                    this.windowShown = false;
                    this.notify();
                }
            }
        }
    }
}

