/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import no.g9.client.component.G9ComboBox;
import no.g9.client.component.G9DesktopPane;
import no.g9.client.component.G9TabPaneManager;
import no.g9.client.component.G9ToolBar;
import no.g9.client.component.menu.G9MenuBar;
import no.g9.client.event.G9WindowEvent;
import no.g9.client.event.G9WindowListener;
import no.g9.client.support.G9DialogController;
import no.g9.exception.G9ClientFrameworkException;

public abstract class G9DialogFrame
extends JInternalFrame {
    protected final Set disabledComponents = new HashSet();
    protected EventListenerList g9WindowEventListeners = new EventListenerList();
    protected Map nameToComponent = new HashMap();
    protected Map componentToName = new HashMap();
    private G9MenuBar menuBar;
    private G9ToolBar toolBar;
    private Set registeredMnemonics;
    private Map<Component, G9TabPaneManager> tabPaneMap = new HashMap<Component, G9TabPaneManager>();
    private static int mouselessModifier = 512;
    protected Set mnemonicsComponents = new HashSet();

    public G9DialogFrame() {
        this("", true, true, true, true);
    }

    public G9DialogFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifable) {
        super(title, resizable, closable, maximizable, iconifable);
        this.setDefaultCloseOperation(0);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JInternalFrame internalFrame;
                if (4L == (e.getChangeFlags() & 4L) && !(internalFrame = (JInternalFrame)e.getSource()).isVisible()) {
                    G9DialogFrame.this.fireG9WindowEvent(25558);
                }
            }
        });
    }

    protected void addNotePage(Component page, G9TabPaneManager manager) {
        this.tabPaneMap.put(page, manager);
    }

    protected G9TabPaneManager getTabManager(Component page) {
        return this.tabPaneMap.get(page);
    }

    protected void fireG9WindowEvent(int id) {
        if (this.g9WindowEventListeners == null) {
            return;
        }
        Object[] listeners = this.g9WindowEventListeners.getListenerList();
        G9WindowEvent e = null;
        block5: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9WindowEvent(this, id);
            }
            if (listeners[i] != G9WindowListener.class) continue;
            switch (e.getID()) {
                case 25556: {
                    ((G9WindowListener)listeners[i + 1]).dialogVisible(e);
                    continue block5;
                }
                case 25557: {
                    ((G9WindowListener)listeners[i + 1]).dialogCreated(e);
                    continue block5;
                }
                case 25558: {
                    ((G9WindowListener)listeners[i + 1]).dialogHidden(e);
                    continue block5;
                }
            }
        }
    }

    public void addG9WindowListener(G9WindowListener l) {
        this.g9WindowEventListeners.add(G9WindowListener.class, l);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
    }

    public void setVisible(boolean visible, boolean firstTimeOpened) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.superSetVisible(visible);
            if (visible && firstTimeOpened) {
                this.getController().setAccessPolicy();
                this.fireG9WindowEvent(25556);
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new VisibleAndAccessTask(visible, firstTimeOpened));
            }
            catch (InterruptedException e) {
                throw new G9ClientFrameworkException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new G9ClientFrameworkException((Throwable)e);
            }
        }
    }

    private void superSetVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setEnabledComponent(Component component, boolean enable) {
        this.setEnabledComponent(component, enable, true);
    }

    public void setEnabledComponent(Component component, boolean enable, boolean delay) {
        EnableTask task = new EnableTask(component, enable);
        if (delay) {
            SwingUtilities.invokeLater(task);
        } else {
            task.run();
        }
    }

    public boolean isEnabledComponent(Component component) {
        return !this.disabledComponents.contains(component);
    }

    private boolean isAncestorDisabled(Component component) {
        if (component == null) {
            return false;
        }
        Container parent = component.getParent();
        if (parent != null && !parent.isEnabled()) {
            return true;
        }
        return this.isAncestorDisabled(parent);
    }

    private void enableComponent(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (!this.disabledComponents.contains(component)) {
                if (container.getParent() != null && container.getParent() instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)container.getParent();
                    pane.setEnabledAt(pane.indexOfComponent(component), true);
                } else {
                    container.setEnabled(true);
                }
                Component[] child = container.getComponents();
                for (int i = 0; i < child.length; ++i) {
                    this.enableComponent(child[i]);
                }
            }
        }
    }

    protected void disableComponent(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (container.getParent() != null && container.getParent() instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)container.getParent();
                pane.setEnabledAt(pane.indexOfComponent(component), false);
            } else {
                container.setEnabled(false);
            }
            Component[] child = container.getComponents();
            for (int i = 0; i < child.length; ++i) {
                this.disableComponent(child[i]);
            }
        }
    }

    public void setVisibleComponent(Component component, boolean visible, boolean delay) {
        VisibleTask visibleTask = new VisibleTask(component, visible);
        if (delay) {
            SwingUtilities.invokeLater(visibleTask);
        } else {
            visibleTask.run();
        }
    }

    public void setVisibleComponent(Component component, boolean visible) {
        this.setVisibleComponent(component, visible, true);
    }

    public JComponent fromNameToComponent(String name) {
        return (JComponent)this.nameToComponent.get(name);
    }

    public String fromComponentToName(JComponent component) {
        return (String)this.componentToName.get(component);
    }

    public void setG9MenuBar(G9MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public G9MenuBar getG9MenuBar() {
        return this.menuBar;
    }

    public void setG9ToolBar(G9ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public G9ToolBar getG9ToolBar() {
        return this.toolBar;
    }

    public abstract G9DialogController getController();

    @Deprecated
    protected int modifyKeyCode(int code) {
        if (code >= 97 && code <= 122) {
            return code - 32;
        }
        switch (code) {
            case 64702: {
                return 112;
            }
            case 64703: {
                return 113;
            }
            case 64704: {
                return 114;
            }
            case 64705: {
                return 115;
            }
            case 64706: {
                return 116;
            }
            case 64707: {
                return 117;
            }
            case 64708: {
                return 118;
            }
            case 64709: {
                return 119;
            }
            case 64710: {
                return 120;
            }
            case 64711: {
                return 121;
            }
            case 64712: {
                return 122;
            }
            case 64713: {
                return 123;
            }
            case 64767: {
                return 127;
            }
            case 64539: {
                return 27;
            }
        }
        return code;
    }

    @Deprecated
    public abstract boolean isModal();

    @Override
    public void setClosed(boolean b) {
        this.doDefaultCloseAction();
    }

    protected Object getNullValueForCell(String attribute) {
        Object retVal = null;
        JComponent editFieldComponent = this.fromNameToComponent(attribute);
        if (editFieldComponent instanceof JCheckBox) {
            retVal = new Boolean(false);
        } else if (editFieldComponent instanceof G9ComboBox) {
            G9ComboBox combo = (G9ComboBox)editFieldComponent;
            retVal = combo.format(combo.getItemAt(0));
        }
        return retVal;
    }

    protected void registerMnemonic(int mnemonic) {
        KeyStroke stroke = KeyStroke.getKeyStroke(mnemonic, mouselessModifier);
        if (this.registeredMnemonics == null) {
            this.registeredMnemonics = new HashSet();
        }
        this.registeredMnemonics.add(stroke);
    }

    protected void addToMnemonicButtons(JButton button) {
        this.mnemonicsComponents.add(button);
    }

    protected void cleanUpMnemonicButtons() {
        for (Component comp : this.mnemonicsComponents) {
            this.remove(comp);
            comp.removeNotify();
        }
    }

    public boolean isRegisteredMnemonic(KeyStroke stroke) {
        return this.registeredMnemonics != null && this.registeredMnemonics.contains(stroke);
    }

    private class VisibleTask
    implements Runnable {
        Component component;
        boolean visible;

        private VisibleTask(Component component, boolean visible) {
            this.component = component;
            this.visible = visible;
        }

        @Override
        public void run() {
            if (this.component instanceof JInternalFrame) {
                G9DialogFrame gFrame;
                if (this.component instanceof G9DialogFrame && (gFrame = (G9DialogFrame)this.component).getController().getWindow() instanceof JDialog) {
                    JDialog dFrame = (JDialog)gFrame.getController().getWindow();
                    dFrame.setVisible(this.visible);
                    return;
                }
                JInternalFrame frame = (JInternalFrame)this.component;
                if (this.visible) {
                    frame.show();
                    G9DesktopPane desktop = (G9DesktopPane)frame.getDesktopPane();
                    if (desktop != null) {
                        desktop.frameShown(frame);
                    }
                    try {
                        frame.setSelected(true);
                        frame.getFocusTraversalPolicy().getDefaultComponent(frame).requestFocus();
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    frame.setVisible(false);
                    G9DesktopPane desktop = (G9DesktopPane)frame.getDesktopPane();
                    if (desktop != null) {
                        desktop.frameHidden(frame);
                    }
                    G9DialogFrame.this.getDesktopPane().repaint();
                }
            } else {
                G9TabPaneManager tabManager = G9DialogFrame.this.getTabManager(this.component);
                if (tabManager != null) {
                    tabManager.setVisible(this.component, this.visible);
                } else {
                    this.component.setVisible(this.visible);
                }
            }
        }
    }

    private class EnableTask
    implements Runnable {
        private Component component;
        private boolean enable;

        private EnableTask(Component component, boolean enable) {
            this.component = component;
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean isAncestorDisabled = G9DialogFrame.this.isAncestorDisabled(this.component);
            if (this.component instanceof G9DialogFrame) {
                G9DialogFrame.this.getG9MenuBar().setEnabledWholeMenuBar(this.enable);
                G9DialogFrame.this.getG9ToolBar().setEnabledWholeToolBar(this.enable);
            }
            if (this.enable) {
                if (G9DialogFrame.this.disabledComponents.remove(this.component) && !isAncestorDisabled) {
                    G9DialogFrame.this.enableComponent(this.component);
                }
            } else if (G9DialogFrame.this.disabledComponents.add(this.component) && !isAncestorDisabled) {
                G9DialogFrame.this.disableComponent(this.component);
            }
        }
    }

    class VisibleAndAccessTask
    implements Runnable {
        boolean visible;
        boolean firstTimeOpened;

        VisibleAndAccessTask(boolean visible, boolean firstTimeOpened) {
            this.visible = visible;
            this.firstTimeOpened = firstTimeOpened;
        }

        @Override
        public void run() {
            G9DialogFrame.this.superSetVisible(this.visible);
            if (this.visible && this.firstTimeOpened) {
                G9DialogFrame.this.getController().setAccessPolicy();
                G9DialogFrame.this.fireG9WindowEvent(25556);
            }
        }
    }
}

