/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.component.menu;

import javax.swing.Action;

/**
 * The view menu
 */
public class G9ViewMenu extends G9Menu {

    /** Reference to the default view menu */
    private static G9ViewMenu defaultViewMenu;

    /**
     * Gets the singleton default view menu. If the default view menu already
     * exist, the title parameter is ignored, otherwise a new view menu is
     * created using the title
     * 
     * @param title the title of the view menu
     * @return the default view menu
     */
    public static G9ViewMenu getDefaultViewMenu(String title) {
        if (defaultViewMenu == null) {
            defaultViewMenu = new G9ViewMenu(title);
        }
        return defaultViewMenu;

    }

    /**
     * Constructs a new <code>JMenu</code> with no text.
     */
    public G9ViewMenu() {
        this("");
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text.
     * 
     * @param s the text for the menu label
     */
    public G9ViewMenu(String s) {
        super(s, G9Menu.VIEW_MENU);
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text
     * and specified as a tear-off menu or not.
     * 
     * @param s the text for the menu label
     * @param b can the menu be torn off (not yet implemented)
     */
    public G9ViewMenu(String s, boolean b) {
        this(s);
    }

    /**
     * Constructs a new <code>JMenu</code> whose properties are taken from the
     * <code>Action</code> supplied.
     * 
     * @param a the <code>Action</code>
     * @since 1.3
     */
    public G9ViewMenu(Action a) {
        this("");
        setAction(a);
    }
    
}
