/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/**
 * The enable event, signalling that a component has been enabled.
 */
public class EnableEvent extends G9Event {
    
    private boolean oldValue;
    private boolean newValue;
    
    /**
     * Constructs a new enable event
     * @param source the source of the event
     * @param oldValue the old enabled value
     * @param newValue the new enabled value
     */
    public EnableEvent(Object source, boolean oldValue, boolean newValue) {
        super(source, 0);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }
    
    /**
     * Returns the old enabled value as a Boolean
     * @return the old enabled value
     */
    public Object getOldValue() {
        return new Boolean(oldValue);
    }
    
    /**
     * Returns the new enabled value as a Boolean
     * @return the new enabled value
     */
    public Object getNewValue() {
        return new Boolean(newValue);
    }

}
