/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;
import java.awt.event.MouseEvent;

/** Wraps a mouse event */
public class G9MouseEventHolder extends G9Event {
    
    /** The wrapped event */
    MouseEvent event;
    
    /** 
     * Constructs a new G9MouseEventHolder
     * @param e the event to wrap.
     */
    public G9MouseEventHolder(MouseEvent e) {
        event = e;
    }
    
    /** 
     * Returns the wrapped mouse event
     * @return the wrapped event.
     */
    public MouseEvent getEvent() {
        return event;
    }
}
