/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.AWTEvent;
import java.awt.event.WindowEvent;

import javax.swing.event.InternalFrameEvent;

/**
 * Adapter class for listening to g9 events. This class provides
 * empty implementations of the methods defined in the G9WindowListener
 * interface.
 * @see no.g9.client.event.G9WindowListener
 */
public abstract class G9WindowAdapter implements G9WindowListener {

    @Override
    public void dialogVisible(G9WindowEvent e) {
        // empty implementation
    }

    @Override
    public void dialogCreated(G9WindowEvent e) {
        // empty implementation
    }
    
    @Override
    public void dialogHidden(G9WindowEvent e) {
        // empty implementation
    }

    @Override
    public void dialogOpened(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogClosing(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogClosed(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogIconified(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogDeiconified(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogActivated(AWTEvent e) {
        // empty implementation
    }

    @Override
    public void dialogDeactivated(AWTEvent e) {
        // empty implementation
    }

   
    
    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        dialogOpened(e);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        dialogClosing(e);

    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        dialogClosed(e);

    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        dialogIconified(e);

    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        dialogDeiconified(e);

    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        dialogActivated(e);
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        dialogDeactivated(e);

    }

    // WindowListener implementation

    @Override
    public void windowOpened(WindowEvent e) {
        dialogOpened(e);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        dialogClosing(e);

    }

    @Override
    public void windowClosed(WindowEvent e) {
        dialogClosed(e);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        dialogIconified(e);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        dialogDeiconified(e);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        dialogActivated(e);

    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        dialogDeactivated(e);
    }

}
