/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;

/**
 * An <code>AWTEvent</code> that adds support for
 * events not supported by the InternalFrameEvent.
 * 
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases. The current serialization support is
 * appropriate for short term storage or RMI between applications running
 * the same version of Swing.  As of 1.4, support for long term storage
 * of all JavaBeans<sup><font size="-2">TM</font></sup>
 * has been added to the <code>java.beans</code> package.
 *
 * @see javax.swing.event.InternalFrameEvent
 * @see java.awt.event.WindowEvent
 * @see java.awt.event.WindowListener
 * @see JInternalFrame
 * @see javax.swing.event.InternalFrameListener
*/
public class G9WindowEvent extends InternalFrameEvent {

    /**
     * Constructs a new g9 window event
     * @param source the source of the event
     * @param id the type of event.
     */
    public G9WindowEvent(JInternalFrame source, int id) {
		super(source, id);
    }
	
    /**
     * The first number in the range of IDs used for g9 window events.
     */
    public static final int G9_DIALOG_FIRST = INTERNAL_FRAME_LAST + 1;

    /**
     * The last number in the range of IDs used for g9 window events.
     */
    public static final int G9_DIALOG_LAST = INTERNAL_FRAME_LAST + 3;

    /**
     * The "dialog visible" event.  This event is delivered each the
     * 
     * time the dialog is made visible internal frame is made visible.
     *
     * @see JInternalFrame#show
     */
    public static final int G9_DIALOG_VISIBLE = G9_DIALOG_FIRST;
    
    /**
     * The "dialog created" event. This event is delivered when 
     * the dialog is created.
     */
    public static final int G9_DIALOG_CREATED = G9_DIALOG_VISIBLE + 1;
    
    /**
     * The "dialog hidden" event. This event is delivered when the dialog
     * is hidden.
     */
    public static final int G9_DIALOG_HIDDEN = G9_DIALOG_CREATED + 1;
    
    /**
     * Returns a parameter string identifying this event.
     * This method is useful for event logging and for debugging.
     *
     * @return a string identifying the event and its attributes
     */
    @Override
    public String paramString() {
        String typeStr;
        switch(id) {
          case G9_DIALOG_VISIBLE:
              typeStr = "G9_DIALOG_VISIBLE";
              break;
          case G9_DIALOG_CREATED:
              typeStr = "G9_DIALOG_CREATED";
              break;
          case G9_DIALOG_HIDDEN:
              typeStr = "G9_DIALOG_HIDDEN";
              break;
        default:
              typeStr = "unknown type";
        }
        return typeStr;
    }


}
