/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;
import java.awt.AWTEvent;
import java.awt.event.WindowEvent;

import javax.swing.event.InternalFrameEvent;

/** 
 * Wrapps either an internal frame events, a window events or an AWT events.
 */
public class G9WindowEventHolder extends G9Event {
    
    /** (missing javadoc) */
    InternalFrameEvent event;
    
    /** (missing javadoc) */
    WindowEvent wEvent;
    
    /** (missing javadoc) */
    AWTEvent awtEvent;
    
    /** 
     * Creates a new event holder, wrapping the specified internal frame event.
     * @param e the internal frame event to wrap.
     */
    public G9WindowEventHolder(InternalFrameEvent e) {
        event = e;
    }
    
    /**
     * Creates a new event holder, wrapping the specified window event
     * @param e the window event to wrap.
     */
    public G9WindowEventHolder(WindowEvent e) {
        wEvent = e;
    }
    
    /**
     * Creates a new event holder, wrapping the specified AWT event.
     * @param e the awt event to wrap.
     */
    public G9WindowEventHolder(AWTEvent e) {
        awtEvent = e;
    }
    
    /** 
     * Returns the internal frame event that is wrapped by this instance.
     * @return the wrapped event
     */
    public InternalFrameEvent getEvent() {
        return event;
    }
    
    /**
     * Returns the window event that is wrapped by this instance.
     * @return the wrapped event
     */
    public WindowEvent getWindowEvent() {
        return wEvent;
    }
    
    /**
     * Returns the awt event that is wrapped by this instance.
     * @return the wrapped event.
     */
    public AWTEvent getAwtEvent() {
        return awtEvent;
    }
}
