/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import no.g9.client.component.G9ComboBox;

/** Internal class */
@SuppressWarnings("rawtypes")
public class LinkField implements ActionListener {

    /** (missing javadoc) */
    G9ComboBox link1;

    /** (missing javadoc) */
    G9ComboBox link2;

    /** (missing javadoc) */
    String id1;

    /** (missing javadoc) */
    String id2;

    /** (missing javadoc) */
    Map data1;

    /** (missing javadoc) */
    Map data2;

    /** (missing javadoc) */
    G9DialogController gc;

    /**
     * Returns the Id1
     *
     * @return the id1
     */
    public String getId1() {
        return id1;
    }

    /**
     * Returns the id2
     *
     * @return the id2
     */
    public String getId2() {
        return id2;
    }

    /**
     * Creates a new LinkField instance
     *
     * @param gc the controller
     */
    public LinkField(G9DialogController gc) {
        this.gc = gc;
    }

    /**
     * Sets the first component
     *
     * @param id1 id of first component
     * @param x the component
     * @param data the data map.
     */
    public void setComponent1(String id1, JComponent x, Map data) {
        this.id1 = id1;
        G9ComboBox cb = (G9ComboBox) x;
        link1 = cb;
        data1 = data;
        cb.addActionListener(this);
    }

    /**
     * Sets the second component
     *
     * @param id2 id of second component
     * @param x the second component
     * @param data the data map
     */
    public void setComponent2(String id2, JComponent x, Map data) {
        this.id2 = id2;
        G9ComboBox cb = (G9ComboBox) x;
        link2 = cb;
        data2 = data;
        cb.addActionListener(this);
    }

    /** Updates the second component */
    public void update1() {
    	SwingUtilities.invokeLater(new Runnable() {
			@Override
            public void run() {
				link2.removeActionListener(LinkField.this);
				gc.display(id2, data1.get(link1.getSelectedItemAsString()));
				link2.addActionListener(LinkField.this);
			}
		});
    }


    /** Updates the first component */
    public void update2() {
    	SwingUtilities.invokeLater(new Runnable() {

			@Override
            public void run() {
				link1.removeActionListener(LinkField.this);
				gc.display(id1, data2.get(link2.getSelectedItemAsString()));
				link1.addActionListener(LinkField.this);
			}

		});
    }

    /**
     * Check if this link is complete
     *
     * @return <code>true</code> if this link is complete.
     */
    public boolean isComplete() {
        return link1 != null && link2 != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        // Object item = e.getItem();
        if (e.getSource() == link1) {
            update1();
        } else if (e.getSource() == link2) {
            update2();
        }
    }

}
