/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

/**
 * The tool tip header class. Extends a JTableHeader adding tool tip functionality.
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class ToolTipHeader extends JTableHeader {

    /** (missing javadoc) */
    String[] toolTips;

    private boolean isBlocked = false;

    /**
     * Creates a new ToolTipHeader with the specified model
     *
     * @param model the table column model
     */
    public ToolTipHeader(TableColumnModel model) {
        super(model);
    }


    @Override
    public String getToolTipText(MouseEvent e) {
        int col  = columnAtPoint(e.getPoint());
        int modelCol = getTable().convertColumnIndexToModel(col);
        String retStr;
        try {
            retStr = toolTips[modelCol];
        } catch (NullPointerException ex) {
            retStr = "";
        } catch (ArrayIndexOutOfBoundsException ex) {
            retStr = "";
        }
        if (retStr.length() < 1) {
            retStr = super.getToolTipText(e);
        }
        return retStr;
    }

    /**
     * Sets the tool tip strings to be used by this tool tip header.
     *
     * @param toolTips array of tool tips.
     */
    public void setToolTipStrings(String[] toolTips) {
      this.toolTips = toolTips.clone();
    }

    /**
     * Sets the tool tip strings to be used by this tool tip header.
     *
     * @param toolTips list of tool tips.
     */
    public void setToolTipStrings(List toolTips) {
        this.toolTips = (String[])toolTips.toArray(new String[0]);
    }

    /**
     * Block all mouse events if and only if the table is disabled
     *
     * @see java.awt.Component#processMouseEvent(java.awt.event.MouseEvent)
     */
    @Override
    protected void processMouseEvent(MouseEvent e) {
        if(this.isEnabled() && !this.isBlocked()) {
            super.processMouseEvent(e);
        }
    }

    /**
     * Internal use. Returns the isBlocked property. A table that is blocked (
     * <code>isBlocked == true</code> will not process any mouse events.
     *
     * @return the value isBlocked property.
     */
    public boolean isBlocked() {
        return isBlocked;
    }


    /**
     * Internal use. Sets the isBlocked property. A table that is blocked (
     * <code>isBlocked == true</code> will not process any mouse events.
     *
     * @param isBlocked the value of the isBlocked property to set.
     */
    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

 }

