/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.RootPaneContainer;
import no.g9.client.support.DialogBlocker;

public class G9Button
extends JButton {
    private boolean inToolbar = false;
    private boolean isBlocked = false;
    private Component lastFocused;

    public G9Button() {
        this(null, null);
    }

    public G9Button(String text) {
        this(text, null);
    }

    public G9Button(Action a) {
        this();
        this.setAction(a);
    }

    public G9Button(Icon icon) {
        this(null, icon);
    }

    public G9Button(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(new ActionHandel());
        this.addFocusListener(new FocusHandel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean wantEvent;
                Container parent;
                for (parent = G9Button.this.getParent(); parent != null && !(parent instanceof RootPaneContainer); parent = parent.getParent()) {
                }
                boolean bl = wantEvent = DialogBlocker.isBlocked(parent) && G9Button.this.getModel().isPressed() && G9Button.this.contains(e.getPoint());
                if (wantEvent) {
                    G9Button.this.doClick();
                }
            }
        });
    }

    public final boolean isInToolbar() {
        return this.inToolbar;
    }

    public void setInToolbar(boolean inToolbar) {
        this.inToolbar = inToolbar;
    }

    @Override
    public void grabFocus() {
        boolean oldEnabled = this.isEnabled();
        this.setEnabled(false);
        super.grabFocus();
        this.setEnabled(oldEnabled);
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (!this.isBlocked) {
            super.processMouseEvent(e);
        }
    }

    private class ActionHandel
    implements ActionListener {
        private ActionHandel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (G9Button.this.isInToolbar() && G9Button.this.lastFocused != null) {
                G9Button.this.lastFocused.requestFocus();
            }
        }
    }

    private class FocusHandel
    extends FocusAdapter {
        private FocusHandel() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (G9Button.this.isInToolbar()) {
                G9Button.this.lastFocused = e.getOppositeComponent();
            }
        }
    }
}

