/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import no.g9.client.component.G9Button;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.EnumeratorDocument;
import no.g9.client.support.G9Document;
import no.g9.client.support.G9FieldValue;
import no.g9.client.support.NumberDocument;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.TypeTool;

public class G9TextField
extends JTextField
implements G9ValueState,
G9FieldValue {
    private Object oldVal;
    private Object initialVal;
    private boolean editable = true;
    private boolean enabled = true;
    private boolean bugFix;
    private int outputJustification = 2;
    private int inputJustification = 2;
    private boolean selectAllOnFocus = false;
    protected EventListenerList vcListeners = new EventListenerList();

    public G9TextField() {
        this(null, null, 0);
    }

    public G9TextField(String text) {
        this(null, text, 0);
    }

    public G9TextField(int columns) {
        this(null, null, columns);
    }

    public G9TextField(String text, int columns) {
        this(null, text, columns);
    }

    public G9TextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((G9Document)G9TextField.this.getDocument()).setInputMode(true);
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                G9TextField.this.oldVal = G9TextField.this.getValue();
                G9TextField.this.setHorizontalAlignment(G9TextField.this.inputJustification);
                if (G9TextField.this.selectAllOnFocus) {
                    G9TextField.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                Object value = G9TextField.this.getValue();
                if (G9TextField.this.oldVal != null ^ value != null || G9TextField.this.oldVal != null && !G9TextField.this.oldVal.equals(value)) {
                    G9TextField.this.fireG9ValueChangedEvent(2000, G9TextField.this.oldVal, value);
                }
                ((G9Document)G9TextField.this.getDocument()).setInputMode(false);
                G9TextField.this.setHorizontalAlignment(G9TextField.this.outputJustification);
                G9TextField.this.setCaretPosition(0);
            }

            private boolean menuOrToolbar(Component opposite) {
                return opposite == null || opposite instanceof JRootPane || opposite instanceof G9Button && ((G9Button)opposite).isInToolbar();
            }
        });
        super.setEditable(true);
        super.setEnabled(true);
        this.editable = true;
        this.enabled = true;
        this.bugFix = TypeTool.isVmVersion1_4();
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            gDoc.setName(this.getName());
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", Name: " + this.getName();
    }

    @Override
    public void resetState() {
        this.initialVal = this.oldVal = this.getValue();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!this.bugFix) {
            return;
        }
        this.enabled = enable;
        if (!enable || this.editable) {
            super.setEditable(enable);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        super.setEditable(editable);
        this.setEnabled(this.enabled);
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    @Override
    public boolean isChanged() {
        if (this.initialVal == null && this.getValue() == null) {
            return false;
        }
        if (this.initialVal != null && this.isBlankWhenZero() && this.initialVal.equals(this.getBlankNumberValue())) {
            return false;
        }
        if (this.initialVal == null ^ this.getValue() == null) {
            return true;
        }
        Object formattedInitial = ((G9Document)this.getDocument()).transform(this.initialVal);
        Object formattedCurrent = ((G9Document)this.getDocument()).transform(this.getValue());
        return formattedCurrent == null ? formattedInitial != null : !formattedCurrent.equals(formattedInitial);
    }

    private Object getBlankNumberValue() {
        Object retVal = this.getValue();
        Document doc = this.getDocument();
        if (doc instanceof NumberDocument && retVal == null) {
            NumberDocument ndoc = (NumberDocument)doc;
            return ndoc.getZeroValue();
        }
        return retVal;
    }

    private boolean isBlankWhenZero() {
        Document doc = this.getDocument();
        if (doc instanceof NumberDocument) {
            NumberDocument ndoc = (NumberDocument)doc;
            return ndoc.getBlankWhenZero();
        }
        return false;
    }

    @Override
    public void display(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && value instanceof String) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.setValue(value);
    }

    @Override
    public void setText(String s) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument) {
            this.setValue(((EnumeratorDocument)doc).toValue(s));
        } else {
            super.setText(s);
        }
    }

    @Override
    public Object getInitialValue() {
        return this.initialVal;
    }

    @Override
    public void setInitialValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && (value instanceof String || value instanceof Integer)) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.oldVal = this.initialVal = value;
    }

    public void setInputJustification(int justification) {
        this.inputJustification = justification;
    }

    public void setOutputJustification(int justification) {
        this.outputJustification = justification;
    }

    @Override
    public void setValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            ((G9Document)doc).setValue(value);
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.setCaretPosition(0);
    }

    @Override
    public Object getValue() {
        Object value = null;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            value = gDoc.getValue();
        } else {
            value = this.getText();
        }
        return value;
    }

    @Override
    public String format() {
        String str = "";
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            str = gDoc.format();
        }
        return str;
    }

    @Override
    public Object parse(String formattedString) {
        Object o = null;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            try {
                o = gDoc.parse(formattedString);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{this.getClass(), this.getName(), formattedString};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1514", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)e, msg);
            }
        }
        return o;
    }

    public Object parse(Object o) {
        return o;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }
}

