/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import no.g9.client.component.G9ComboBox;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.G9DialogController;
import no.g9.client.support.G9FieldValue;

public class ComponentLink {
    private static Map linkGraf = new WeakHashMap();

    private static boolean getFlag(JComponent from, JComponent to) {
        Flag fromFlag = (Flag)linkGraf.get(from);
        Flag toFlag = (Flag)linkGraf.get(to);
        if (toFlag.isRaised()) {
            return false;
        }
        fromFlag.raiseFlag();
        return true;
    }

    private static void returnFlag(JComponent from) {
        Flag fromFlag = (Flag)linkGraf.get(from);
        fromFlag.lowerFlag();
    }

    private static void addToGraph(JComponent from, JComponent to) {
        if (!linkGraf.containsKey(from)) {
            linkGraf.put(from, new Flag());
        }
        if (!linkGraf.containsKey(to)) {
            linkGraf.put(to, new Flag());
        }
    }

    private static void copyState(Object from, Object to) {
        if (from instanceof G9ValueState && to instanceof G9ValueState) {
            G9ValueState fs = (G9ValueState)from;
            G9ValueState ts = (G9ValueState)to;
            ts.setInitialValue(fs.getInitialValue());
        }
    }

    public static void link(final JTextComponent fromTextComponent, final JTextComponent toTextComponent, String attributeName, G9DialogController controller, String nodeName) {
        ComponentLink.addToGraph(fromTextComponent, toTextComponent);
        fromTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            private void updateComponent() {
                if (ComponentLink.getFlag(fromTextComponent, toTextComponent)) {
                    ComponentLink.copyState(fromTextComponent, toTextComponent);
                    ((G9ValueState)((Object)toTextComponent)).display(((G9FieldValue)((Object)fromTextComponent)).getValue());
                    ComponentLink.returnFlag(fromTextComponent);
                }
            }
        });
    }

    public static void link(final JComboBox fromComboBox, final JTextComponent toTextComponent, String attributeName, G9DialogController controller, String nodeName) {
        ComponentLink.addToGraph(fromComboBox, toTextComponent);
        fromComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateComponent();
            }

            private void updateComponent() {
                if (ComponentLink.getFlag(fromComboBox, toTextComponent)) {
                    Object initialValue = ((G9ComboBox)fromComboBox).getInitialValue();
                    if ((initialValue = ((G9ComboBox)fromComboBox).format(initialValue)) != null) {
                        try {
                            initialValue = ((G9FieldValue)((Object)toTextComponent)).parse((String)initialValue);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    ((G9ValueState)((Object)toTextComponent)).setInitialValue(initialValue);
                    Object item = null;
                    item = fromComboBox.getItemAt(fromComboBox.getSelectedIndex());
                    item = ((G9ComboBox)fromComboBox).format(item);
                    if (item != null) {
                        try {
                            item = ((G9FieldValue)((Object)toTextComponent)).parse((String)item);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    ((G9ValueState)((Object)toTextComponent)).display(item);
                    ComponentLink.returnFlag(fromComboBox);
                }
            }
        });
    }

    public static void link(final JComboBox fromComboBox, final JComboBox toComboBox, String attributeName, G9DialogController controller, String nodeName) {
        ComponentLink.addToGraph(fromComboBox, toComboBox);
        fromComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.updateComponent();
            }

            private void updateComponent() {
                if (ComponentLink.getFlag(fromComboBox, toComboBox)) {
                    ComponentLink.copyState(fromComboBox, toComboBox);
                    G9ComboBox toC = (G9ComboBox)toComboBox;
                    G9ComboBox fromC = (G9ComboBox)fromComboBox;
                    Object item = null;
                    item = fromC.getItemAt(fromC.getSelectedIndex());
                    if (fromC.isDontFire()) {
                        toC.display(item);
                    } else {
                        toC.setSelectedItem(item);
                    }
                    ComponentLink.returnFlag(fromComboBox);
                }
            }
        });
    }

    public static void link(final JToggleButton fromButton, final JToggleButton toButton, String attributeName, G9DialogController controller, String nodeName) {
        ComponentLink.addToGraph(fromButton, toButton);
        fromButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                this.updateComponent();
            }

            private void updateComponent() {
                if (ComponentLink.getFlag(fromButton, toButton)) {
                    ComponentLink.copyState(fromButton, toButton);
                    ((G9ValueState)((Object)toButton)).display(new Boolean(fromButton.isSelected()));
                    ComponentLink.returnFlag(fromButton);
                }
            }
        });
    }

    public static void link(final JTextComponent fromTextComponent, final JComboBox toComboComponent, String attributeName, G9DialogController controller, String nodeName) {
        ComponentLink.addToGraph(fromTextComponent, toComboComponent);
        fromTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateComponent();
            }

            private void updateComponent() {
                if (ComponentLink.getFlag(fromTextComponent, toComboComponent)) {
                    ComponentLink.copyState(fromTextComponent, toComboComponent);
                    ((G9ComboBox)toComboComponent).display(((G9FieldValue)((Object)fromTextComponent)).getValue());
                    ComponentLink.returnFlag(fromTextComponent);
                }
            }
        });
    }

    private static class Flag {
        private boolean flag = false;

        Flag() {
        }

        public void raiseFlag() {
            this.flag = true;
        }

        public void lowerFlag() {
            this.flag = false;
        }

        public boolean isRaised() {
            return this.flag;
        }
    }
}

