/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import no.g9.client.component.G9ButtonGroup;
import no.g9.client.component.G9RadioButton;
import no.g9.client.support.G9DialogController;

public class CustomTraversalPolicy
extends FocusTraversalPolicy {
    private Map frameComponentToIndex;
    private Component[] componentSequence;
    private Component lastFocusedComponent = null;

    public CustomTraversalPolicy(G9DialogController controller, String[] componentOrder) {
        this.frameComponentToIndex = this.initFocusIndex(controller, componentOrder);
        this.componentSequence = this.initComponentArray(this.frameComponentToIndex);
        this.addFocusListeners();
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component next = null;
        Integer curIndex = (Integer)this.frameComponentToIndex.get(aComponent);
        if (curIndex != null) {
            for (int i = curIndex + 1; i < this.componentSequence.length; ++i) {
                next = this.componentSequence[i];
                if (!this.acceptFocus(next)) continue;
                return next;
            }
        }
        return this.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component previous = null;
        Integer curIndex = (Integer)this.frameComponentToIndex.get(aComponent);
        if (curIndex != null) {
            for (int i = curIndex - 1; i >= 0; --i) {
                previous = this.componentSequence[i];
                if (!this.acceptFocus(previous)) continue;
                return previous;
            }
        }
        return this.getLastComponent(focusCycleRoot);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.acceptFocus(this.lastFocusedComponent) ? this.lastFocusedComponent : this.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        Component first = null;
        for (int i = 0; i < this.componentSequence.length && first == null; ++i) {
            first = this.componentSequence[i];
            if (this.acceptFocus(first)) continue;
            first = null;
        }
        return first;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        Component last = null;
        for (int i = this.componentSequence.length - 1; i >= 0 && last == null; --i) {
            last = this.componentSequence[i];
            if (this.acceptFocus(last)) continue;
            last = null;
        }
        return last;
    }

    private boolean acceptFocus(Component component) {
        boolean accept;
        boolean bl = accept = component != null && component.isEnabled() && component.isFocusable() && component.isShowing();
        if (component instanceof G9RadioButton) {
            G9RadioButton rGrpButton = (G9RadioButton)component;
            ButtonModel model = rGrpButton.getGroup().getSelection();
            accept = accept && (rGrpButton.getGroup().isClear() || model == rGrpButton.getModel());
        }
        return accept;
    }

    private Component[] initComponentArray(Map componentToIndex) {
        Component[] components = new Component[componentToIndex.size()];
        for (Component comp : componentToIndex.keySet()) {
            int index = (Integer)componentToIndex.get(comp);
            components[index] = comp;
        }
        return components;
    }

    private Map initFocusIndex(G9DialogController controller, String[] componentOrder) {
        HashMap<JComponent, Integer> componentToIndex = new HashMap<JComponent, Integer>();
        int radioGroupOffset = 0;
        for (int i = 0; i < componentOrder.length; ++i) {
            Component comp = controller.getView().fromNameToComponent(componentOrder[i]);
            if ((comp = this.comboBoxCheck(comp)) instanceof G9ButtonGroup.ComponentGroup) {
                G9ButtonGroup buttonComp = ((G9ButtonGroup.ComponentGroup)comp).getGroup();
                Enumeration<AbstractButton> e = buttonComp.getElements();
                if (e.hasMoreElements()) {
                    e.nextElement();
                }
                while (e.hasMoreElements()) {
                    comp = e.nextElement();
                    componentToIndex.put((JComponent)comp, new Integer(i + radioGroupOffset));
                    ++radioGroupOffset;
                }
                --radioGroupOffset;
                continue;
            }
            componentToIndex.put((JComponent)comp, new Integer(i + radioGroupOffset));
        }
        return componentToIndex;
    }

    private Component comboBoxCheck(Component comp) {
        JComboBox combo;
        Component retVal = comp;
        if (retVal instanceof JComboBox && (combo = (JComboBox)retVal).isEditable()) {
            retVal = combo.getEditor().getEditorComponent();
        }
        return retVal;
    }

    private void addFocusListeners() {
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CustomTraversalPolicy.this.lastFocusedComponent = (Component)e.getSource();
            }
        };
        for (int i = 0; i < this.componentSequence.length; ++i) {
            Component component = this.componentSequence[i];
            component.addFocusListener(listener);
        }
    }
}

