/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.CustomDate;
import org.joda.time.DateMidnight;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateMidnightDocument
extends G9Document {
    public DateMidnightDocument(int datatype, String inputFormat, String outputFormat, int maxLength) {
        super(datatype, inputFormat, outputFormat, maxLength);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (!this.getInputMode()) {
            super.insertString(offset, str, attr);
            return;
        }
        String format = this.getInputFormat();
        if (str.length() + this.getLength() > format.length()) {
            return;
        }
        char aChar = str.charAt(0);
        char fChar = format.charAt(offset);
        if (Character.isDigit(aChar) == Character.isLetter(fChar) && (Character.isLetterOrDigit(fChar) || !Character.isLetterOrDigit(aChar))) {
            char bChar;
            super.insertString(offset, str, attr);
            if (!(++offset >= format.length() || Character.isLetterOrDigit(bChar = format.charAt(offset)) || this.getLength() != offset && this.getText(offset, 1).charAt(0) == bChar)) {
                super.insertString(offset, "" + bChar, attr);
            }
        }
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.stringToDate(this.dateToString((DateMidnight)o));
    }

    @Override
    public synchronized void setValue(Object value) {
        String buf = null;
        super.setValue(value);
        if (value != null) {
            DateMidnight dt = (DateMidnight)value;
            buf = dt.toString(this.getFormat());
        }
        try {
            this.replace(0, this.getLength(), buf, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(DateMidnightDocument.class).warn((Object)"Failed to set value.", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result = super.getValue();
        if (this.getInputMode()) {
            String strValue = null;
            try {
                strValue = this.getText(0, this.getLength());
            }
            catch (BadLocationException e) {
                Logger.getLogger(DateMidnightDocument.class).warn((Object)"Failed to get value.", (Throwable)e);
            }
            if (strValue != null && (strValue.length() != 0 || result != null)) {
                result = this.getFormatter().parseDateTime(strValue).toDateMidnight();
            }
        }
        return result;
    }

    @Override
    public synchronized String format() {
        String str = "";
        DateMidnight dt = (DateMidnight)this.getValue();
        if (dt != null) {
            str = dt.toString(this.getInternalFormat());
        }
        return str;
    }

    @Override
    public synchronized Object parse(String str) {
        DateMidnight value = null;
        if (str != null && str.length() != 0) {
            value = this.getInternalFormatter().parseDateTime(str).toDateMidnight();
        }
        return value;
    }

    @Override
    public synchronized String getOutputText() {
        return this.getValue() != null ? ((DateMidnight)this.getValue()).toString(this.getOutputFormat()) : null;
    }

    private String dateToString(DateMidnight date) {
        if (date != null) {
            return date.toString(this.getFormat());
        }
        return "";
    }

    private DateMidnight stringToDate(String str) {
        if (str != null && !str.isEmpty()) {
            return this.getFormatter().parseDateTime(str).toDateMidnight();
        }
        return null;
    }

    private DateTimeFormatter getFormatter() {
        return DateTimeFormat.forPattern((String)this.getFormat());
    }

    private String getFormat() {
        return this.getInputMode() ? this.getInputFormat() : this.getOutputFormat();
    }

    private DateTimeFormatter getInternalFormatter() {
        return DateTimeFormat.forPattern((String)this.getInternalFormat());
    }

    private String getInternalFormat() {
        return CustomDate.getDatetimeInternalFormat((int)this.getDatatype());
    }
}

