/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import no.g9.client.component.EnableManager;
import no.g9.client.component.G9Button;
import no.g9.client.component.G9DesktopPane;
import no.g9.client.component.G9ToolBar;
import no.g9.client.component.menu.G9Menu;
import no.g9.client.component.menu.G9MenuBar;
import no.g9.client.component.menu.G9MenuItem;
import no.g9.client.support.G9DialogFrame;
import no.g9.client.support.G9Table;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class DialogBlocker {
    private static boolean doSelect = true;
    private static final boolean BLOCK = true;
    private static final boolean UNBLOCK = false;
    private static final KeyboardBlockManager keyBlock = new KeyboardBlockManager();
    private static final Map blockedWindows = new HashMap();
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private static EnableManager enableManager = new EnableManager();
    private static boolean applicationBlock = false;
    private static final Map dialogToListblocks = new HashMap();
    private static final MouseAdapter MOUSE_BLOCK = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Component comp;
            this.listblockProcess(e);
            if (!doSelect) {
                return;
            }
            for (comp = (Component)e.getSource(); comp != null && !(comp instanceof JInternalFrame); comp = comp.getParent()) {
            }
            if (comp != null) {
                JInternalFrame frame = (JInternalFrame)comp;
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private void listblockProcess(MouseEvent e) {
            Component comp = (Component)e.getSource();
            while (!(comp instanceof RootPaneContainer)) {
                comp = comp.getParent();
            }
            if (comp instanceof JFrame) {
                return;
            }
            Set listblocks = (Set)dialogToListblocks.get(comp);
            boolean processed = false;
            Iterator it = listblocks.iterator();
            while (it.hasNext() && !processed) {
                G9Table table = (G9Table)it.next();
                processed = table.processDoubleClickMouseEvent(e);
            }
        }
    };
    private static final InternalFrameListener frameAdapter = new InternalFrameAdapter(){

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            JInternalFrame frame = (JInternalFrame)e.getSource();
            frame.getGlassPane().setVisible(true);
        }
    };
    private static final WindowListener windowAdapter = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            RootPaneContainer rootPane = (RootPaneContainer)e.getSource();
            rootPane.getGlassPane().setVisible(true);
        }
    };

    private static final void toggleListener(RootPaneContainer rootPane, boolean block) {
        if (rootPane instanceof JInternalFrame) {
            JInternalFrame internalFrame = (JInternalFrame)rootPane;
            if (block) {
                internalFrame.addInternalFrameListener(frameAdapter);
            } else {
                internalFrame.removeInternalFrameListener(frameAdapter);
            }
        } else {
            Window window = (Window)((Object)rootPane);
            if (block) {
                window.addWindowListener(windowAdapter);
            } else {
                window.removeWindowListener(windowAdapter);
            }
        }
    }

    private static final void toggleEditMenu(RootPaneContainer rootPane) {
        G9DialogFrame internalFrame;
        JDesktopPane desktopPane;
        if (rootPane instanceof G9DialogFrame && (desktopPane = (internalFrame = (G9DialogFrame)rootPane).getDesktopPane()) != null && desktopPane instanceof G9DesktopPane) {
            ((G9DesktopPane)desktopPane).toggleEditMenu(internalFrame);
        }
    }

    private static void toggleGlassPaneVisibility(RootPaneContainer rootPane) {
        if (rootPane instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)rootPane;
            if (frame.isSelected()) {
                frame.getGlassPane().setVisible(false);
            } else if (frame.isShowing()) {
                frame.getDesktopPane().getDesktopManager().deactivateFrame(frame);
            }
        } else if (rootPane instanceof Window) {
            rootPane.getGlassPane().setVisible(!((Window)((Object)rootPane)).isActive());
        }
    }

    private static void toggleToolBarComponents(RootPaneContainer documentWindow, boolean block) {
        if (documentWindow instanceof G9DialogFrame) {
            G9DialogFrame gdf = (G9DialogFrame)documentWindow;
            G9ToolBar toolbar = gdf.getG9ToolBar();
            if (toolbar == null) {
                return;
            }
            Component[] components = toolbar.getG9Components();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof G9Button)) continue;
                G9Button button = (G9Button)components[i];
                button.setCursor(block ? WAIT_CURSOR : DEFAULT_CURSOR);
                button.setBlocked(block);
            }
        }
    }

    private static boolean isApplicationBlocked() {
        return applicationBlock;
    }

    private static void registerListblocks(RootPaneContainer rootPane, boolean block) {
        if (!block) {
            dialogToListblocks.remove(rootPane);
        } else {
            HashSet listblocks = new HashSet();
            dialogToListblocks.put(rootPane, listblocks);
            DialogBlocker.getListblocks((Component)((Object)rootPane), listblocks);
        }
    }

    private static void getListblocks(Component component, Set listblocks) {
        if (component instanceof G9Table) {
            listblocks.add(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                DialogBlocker.getListblocks(components[i], listblocks);
            }
        }
    }

    private static void addMenuKeyStrokes(Component component) {
        if (component instanceof JMenuItem) {
            G9Menu g9Menu;
            Component[] menuItems;
            JMenuItem menuItem = (JMenuItem)component;
            if (menuItem.getAccelerator() != null) {
                DialogBlocker.keyBlock.addAllowedKeyStroke(menuItem.getAccelerator());
            }
            if (menuItem instanceof G9Menu && (menuItems = (g9Menu = (G9Menu)menuItem).getG9Components()) != null) {
                for (int i = 0; i < menuItems.length; ++i) {
                    DialogBlocker.addMenuKeyStrokes(menuItems[i]);
                }
            }
        }
    }

    private static void toggleMenuBar(RootPaneContainer documentWindow, boolean block) {
        if (documentWindow == null) {
            return;
        }
        G9MenuBar menuBar = null;
        if (documentWindow instanceof G9DialogFrame) {
            menuBar = ((G9DialogFrame)documentWindow).getG9MenuBar();
        }
        if (menuBar == null) {
            return;
        }
        Component[] components = menuBar.getG9Components();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof G9Menu)) continue;
            G9Menu g9Menu = (G9Menu)components[i];
            Component[] mComponents = g9Menu.getG9Components();
            for (int j = 0; j < mComponents.length; ++j) {
                if (!(mComponents[j] instanceof G9MenuItem)) continue;
                G9MenuItem menuItem = (G9MenuItem)mComponents[j];
                enableManager.setEnabled(menuItem, !block);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void block(RootPaneContainer rootPane) {
        BlockTask blockTask = new BlockTask(rootPane);
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(blockTask);
                if (msgID == null) return;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return;
                Object[] msgArgs = new Object[]{DialogBlocker.class, "block", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{DialogBlocker.class, "block", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{DialogBlocker.class, "block", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{DialogBlocker.class, "block", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        blockTask.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unblock(RootPaneContainer rootPane) {
        UnblockTask unblockTask = new UnblockTask(rootPane);
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(unblockTask);
                if (msgID == null) return;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return;
                Object[] msgArgs = new Object[]{DialogBlocker.class, "unblock", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{DialogBlocker.class, "unblock", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{DialogBlocker.class, "unblock", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{DialogBlocker.class, "unblock", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        unblockTask.run();
    }

    public static boolean isBlocked(Component rootPane) {
        return blockedWindows.containsKey(rootPane);
    }

    public static void addAllowedKeyStrokesFromMenuBar(JMenuBar menuBar) {
        Component[] menuBarComponents = menuBar.getComponents();
        if (menuBarComponents != null) {
            for (int i = 0; i < menuBarComponents.length; ++i) {
                if (!(menuBarComponents[i] instanceof JMenu)) continue;
                JMenu menu = (JMenu)menuBarComponents[i];
                DialogBlocker.addMenuKeyStrokes(menu);
            }
        }
    }

    public static void addAllowedMnemonicsFromButtons(Component component) {
        Container container;
        Component[] containerComponents;
        AbstractButton button;
        if (component instanceof AbstractButton && (button = (AbstractButton)component).getMnemonic() != 0) {
            KeyStroke stroke = KeyStroke.getKeyStroke(button.getMnemonic(), 512);
            DialogBlocker.keyBlock.addAllowedKeyStroke(stroke);
        }
        if (component instanceof Container && (containerComponents = (container = (Container)component).getComponents()) != null) {
            for (int i = 0; i < containerComponents.length; ++i) {
                DialogBlocker.addAllowedMnemonicsFromButtons(containerComponents[i]);
            }
        }
    }

    public static void addAllowedKeyStroke(KeyStroke stroke) {
        DialogBlocker.keyBlock.addAllowedKeyStroke(stroke);
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyBlock);
    }

    private static class UnblockTask
    implements Runnable {
        private RootPaneContainer rootPane;

        UnblockTask(RootPaneContainer rootPane) {
            this.rootPane = rootPane;
        }

        @Override
        public void run() {
            Component glassPaneComponent = (Component)blockedWindows.remove(this.rootPane);
            if (glassPaneComponent != null) {
                DialogBlocker.toggleListener(this.rootPane, false);
                DialogBlocker.toggleToolBarComponents(this.rootPane, false);
                DialogBlocker.toggleMenuBar(this.rootPane, false);
                DialogBlocker.toggleEditMenu(this.rootPane);
                DialogBlocker.registerListblocks(this.rootPane, false);
                if (this.rootPane instanceof JInternalFrame) {
                    this.rootPane.setGlassPane(glassPaneComponent);
                } else {
                    this.rootPane.getGlassPane().removeMouseListener(MOUSE_BLOCK);
                    this.rootPane.getGlassPane().setCursor(DEFAULT_CURSOR);
                    if (this.rootPane instanceof JFrame) {
                        applicationBlock = false;
                    }
                }
                DialogBlocker.toggleGlassPaneVisibility(this.rootPane);
            }
        }
    }

    private static class BlockTask
    implements Runnable {
        private RootPaneContainer rootPane;

        BlockTask(RootPaneContainer rootPane) {
            this.rootPane = rootPane;
        }

        @Override
        public void run() {
            if (!blockedWindows.containsKey(this.rootPane) && ((Component)((Object)this.rootPane)).isShowing()) {
                blockedWindows.put(this.rootPane, this.rootPane.getGlassPane());
                DialogBlocker.toggleListener(this.rootPane, true);
                DialogBlocker.toggleToolBarComponents(this.rootPane, true);
                DialogBlocker.toggleMenuBar(this.rootPane, true);
                DialogBlocker.toggleEditMenu(this.rootPane);
                if (!(this.rootPane instanceof JFrame)) {
                    DialogBlocker.registerListblocks(this.rootPane, true);
                }
                if (this.rootPane instanceof JInternalFrame) {
                    BlockPane blockPane = new BlockPane();
                    this.rootPane.setGlassPane(blockPane);
                    blockPane.setVisible(true);
                } else {
                    this.rootPane.getGlassPane().addMouseListener(MOUSE_BLOCK);
                    this.rootPane.getGlassPane().setCursor(WAIT_CURSOR);
                    this.rootPane.getGlassPane().setVisible(true);
                    if (this.rootPane instanceof JFrame) {
                        applicationBlock = true;
                    }
                }
            }
        }
    }

    private static class KeyboardBlockManager
    extends DefaultKeyboardFocusManager {
        private final Set keyStrokesAllowedThrough = new HashSet();
        private final KeyStroke ctrlF6 = KeyStroke.getKeyStroke(117, 128);
        private final KeyStroke ctrlShiftF6 = KeyStroke.getKeyStroke(117, 192);
        private final KeyStroke alt = KeyStroke.getKeyStroke(18, 0);
        private final KeyStroke altGr = KeyStroke.getKeyStroke(65406, 0);
        private final KeyStroke ctrlF4 = KeyStroke.getKeyStroke(115, 128);

        public KeyboardBlockManager() {
            this.addAllowedKeyStroke(this.ctrlF6);
            this.addAllowedKeyStroke(this.ctrlF6);
            this.addAllowedKeyStroke(this.ctrlShiftF6);
            this.addAllowedKeyStroke(this.alt);
            this.addAllowedKeyStroke(this.altGr);
            this.addAllowedKeyStroke(this.ctrlF4);
        }

        private void addAllowedKeyStroke(KeyStroke allowedKeyStroke) {
            this.keyStrokesAllowedThrough.add(allowedKeyStroke);
        }

        private Set getAllowedKeyStrokes() {
            return this.keyStrokesAllowedThrough;
        }

        private boolean isAllowedKey(Component source, KeyEvent e) {
            KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
            boolean allowed = this.getAllowedKeyStrokes().contains(stroke);
            if (allowed && source instanceof JInternalFrame) {
                JInternalFrame fSource = (JInternalFrame)source;
                boolean bl = allowed = fSource.getRootPane().getInputMap(2).get(stroke) == null;
            }
            if (allowed && source instanceof G9DialogFrame) {
                G9DialogFrame gSource = (G9DialogFrame)source;
                allowed = !gSource.isRegisteredMnemonic(stroke);
            }
            return allowed;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            Object o = e.getSource();
            Component comp = null;
            if (o instanceof Component) {
                for (comp = (Component)o; comp != null && !(comp instanceof RootPaneContainer) && !(comp instanceof JOptionPane); comp = comp.getParent()) {
                }
            }
            return !(comp instanceof JOptionPane) && (DialogBlocker.isApplicationBlocked() || comp != null && !this.isAllowedKey(comp, e) && blockedWindows.containsKey(comp));
        }
    }

    private static final class BlockPane
    extends JPanel {
        BlockPane() {
            this.setOpaque(false);
            this.setCursor(WAIT_CURSOR);
            this.addMouseListener(MOUSE_BLOCK);
        }
    }
}

