/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.esito.util.EnumUtil;
import no.g9.client.support.G9Document;
import no.g9.domain.G9Enums;
import no.g9.support.G9Enumerator;
import no.g9.support.ObjectFactory;

public class EnumeratorDocument
extends G9Document {
    private G9Enums enumerations;
    private Object enumValue;
    private Class enumClass;
    String enumTypeName;

    public EnumeratorDocument(int datatype, String inputFormat, String outputFormat, int maxLength, G9Enums enumerations, Class enumClass) {
        super(datatype, inputFormat, outputFormat, maxLength);
        this.enumClass = enumClass;
        this.enumerations = enumerations;
        this.enumTypeName = enumClass.getName();
        String[] foo = this.enumTypeName.split("\\.");
        this.enumTypeName = foo[foo.length - 1];
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        int maxLength = this.getMaxLength();
        if (str != null && maxLength > 0 && offset + str.length() > this.getMaxLength()) {
            int newlen = this.getMaxLength() - offset;
            if (newlen <= 0) {
                return;
            }
            str = str.substring(0, newlen);
        }
        super.insertString(offset, str, attr);
    }

    @Override
    public synchronized void setValue(Object value) {
        super.setValue(value);
        String textValue = "";
        if (value != null && (value instanceof G9Enumerator || value.getClass().isEnum())) {
            this.enumValue = value;
            textValue = EnumUtil.getEnumLiteral((Object)this.enumValue);
        }
        try {
            this.replace(0, this.getLength(), textValue, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(EnumeratorDocument.class).warn((Object)"Failed to set value", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result = super.getValue();
        if (this.getInputMode()) {
            String strValue = null;
            try {
                strValue = this.getText(0, this.getLength());
            }
            catch (BadLocationException e) {
                Logger.getLogger(EnumeratorDocument.class).warn((Object)"Failed to get value", (Throwable)e);
            }
            if (strValue != null) {
                result = strValue;
            }
        }
        return this.toValue(result);
    }

    public Object toValue(Object obj) {
        if (obj == null || obj instanceof G9Enumerator || obj.getClass().isEnum()) {
            return obj;
        }
        int curVal = -1;
        if (obj instanceof String) {
            String text = (String)obj;
            curVal = this.enumerations.toValue(this.enumTypeName, text);
        } else if (obj instanceof Integer) {
            Integer curValObj = (Integer)obj;
            curVal = curValObj;
        }
        if (curVal == Integer.MIN_VALUE) {
            return null;
        }
        if (this.enumClass.isEnum()) {
            return EnumUtil.getEnumObject((String)this.enumClass.getName(), (int)curVal);
        }
        G9Enumerator enumerator = (G9Enumerator)ObjectFactory.newObject((String)this.enumClass.getName());
        enumerator.setCurrentValue(curVal);
        return enumerator;
    }

    @Override
    public synchronized String format() {
        return this.enumToString(this.getValue());
    }

    private String enumToString(Object enumerator) {
        if (enumerator != null) {
            return EnumUtil.getEnumLiteral((Object)enumerator);
        }
        return "";
    }

    @Override
    public synchronized Object transform(Object o) {
        Object retVal;
        try {
            retVal = this.parse(this.enumToString(o));
        }
        catch (ParseException e) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public synchronized Object parse(String str) throws ParseException {
        Object result = null;
        if (str != null && str.length() != 0) {
            result = EnumUtil.getEnumObject((String)this.enumClass.getName(), (String)str);
        }
        return result;
    }
}

