/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.g9.client.support.G9DialogController;
import no.g9.exception.G9BaseException;

public class G9Worker {
    private static Map<Object, G9Worker> controllerToWorker;
    private Worker worker;
    private static int workerCount;

    public static synchronized G9Worker enqueueTask(Object controller, Runnable task) {
        G9Worker worker = G9Worker.getWorker(controller);
        worker.enqueue(task);
        return worker;
    }

    public static synchronized G9Worker getWorker(Object controller) {
        G9Worker g9Worker;
        if (controllerToWorker == null) {
            controllerToWorker = Collections.synchronizedMap(new HashMap());
        }
        if ((g9Worker = controllerToWorker.get(controller)) == null || !g9Worker.isRunning()) {
            String workerName;
            if (controller instanceof G9DialogController) {
                G9DialogController gdc = (G9DialogController)controller;
                workerName = gdc.getDialogName();
            } else {
                workerName = "#" + workerCount++;
            }
            g9Worker = new G9Worker(workerName);
            controllerToWorker.put(controller, g9Worker);
        }
        return g9Worker;
    }

    private G9Worker(String workerName) {
        this.worker = new Worker(workerName);
        this.worker.start();
    }

    public boolean waitOnQueue() {
        return this.worker.waitOnQueue();
    }

    public synchronized void enqueue(Runnable task) {
        this.worker.enqueue(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void relinquish() {
        this.worker.relinquish();
        Map<Object, G9Worker> map = controllerToWorker;
        synchronized (map) {
            for (Object key : controllerToWorker.keySet()) {
                if (controllerToWorker.get(key) != this) continue;
                controllerToWorker.remove(key);
                break;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.worker.isAlive();
    }

    public synchronized boolean isEmpty() {
        return this.worker.isEmpty();
    }

    static {
        workerCount = 0;
    }

    private static class Worker
    extends Thread {
        private boolean doWork = true;
        private List<Runnable> queue = new ArrayList<Runnable>();
        private boolean working = false;

        public Worker(String workerName) {
            super("G9Worker-" + workerName);
            this.setPriority(5);
        }

        public synchronized boolean waitOnQueue() {
            while (!this.queue.isEmpty() || this.isWorking()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return this.queue.isEmpty();
        }

        private synchronized boolean isWorking() {
            return this.working;
        }

        public synchronized void enqueue(Runnable task) {
            this.queue.add(task);
            this.notify();
        }

        public synchronized boolean isEmpty() {
            return this.queue.size() == 0;
        }

        public synchronized boolean isRunning() {
            return this.doWork;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.doWork) {
                try {
                    Runnable next = this.dequeue();
                    if (next == null) {
                        this.doWork = false;
                        break;
                    }
                    Thread task = new Thread(next);
                    this.startWork();
                    task.start();
                    try {
                        task.join();
                    }
                    catch (InterruptedException e) {
                        task.interrupt();
                    }
                }
                catch (G9BaseException g9BaseException) {}
                continue;
                finally {
                    this.endWork();
                }
            }
        }

        private synchronized void endWork() {
            this.working = false;
            this.notify();
        }

        private synchronized void startWork() {
            this.working = true;
        }

        public synchronized Runnable dequeue() {
            while (this.queue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.startWork();
            this.notifyAll();
            return this.queue.remove(0);
        }

        public synchronized void relinquish() {
            this.enqueue(null);
        }
    }
}

