/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.CustomDate;

public class LocalDateDocument
extends G9Document {
    public LocalDateDocument(int datatype, String inputFormat, String outputFormat, int maxLength) {
        super(datatype, inputFormat, outputFormat, maxLength);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (!this.getInputMode()) {
            super.insertString(offset, str, attr);
            return;
        }
        String format = this.getInputFormat();
        if (str.length() + this.getLength() > format.length()) {
            return;
        }
        char aChar = str.charAt(0);
        char fChar = format.charAt(offset);
        if (Character.isDigit(aChar) == Character.isLetter(fChar) && (Character.isLetterOrDigit(fChar) || !Character.isLetterOrDigit(aChar))) {
            char bChar;
            super.insertString(offset, str, attr);
            if (!(++offset >= format.length() || Character.isLetterOrDigit(bChar = format.charAt(offset)) || this.getLength() != offset && this.getText(offset, 1).charAt(0) == bChar)) {
                super.insertString(offset, "" + bChar, attr);
            }
        }
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.stringToDate(this.dateToString((LocalDate)o));
    }

    @Override
    public synchronized void setValue(Object value) {
        String buf = null;
        super.setValue(value);
        if (value != null) {
            LocalDate ld = (LocalDate)value;
            buf = ld.format(DateTimeFormatter.ofPattern(this.getFormat()));
        }
        try {
            this.replace(0, this.getLength(), buf, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(LocalDateDocument.class).warn((Object)"Failed to set value.", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result;
        block6: {
            result = super.getValue();
            if (this.getInputMode()) {
                String strValue = null;
                try {
                    strValue = this.getText(0, this.getLength());
                }
                catch (BadLocationException e) {
                    Logger.getLogger(LocalDateDocument.class).warn((Object)"Failed to get value.", (Throwable)e);
                }
                if (strValue != null && (strValue.length() != 0 || result != null)) {
                    try {
                        result = LocalDate.parse(strValue, DateTimeFormatter.ofPattern(this.getFormat()));
                    }
                    catch (DateTimeParseException e) {
                        if (strValue.length() != 0) break block6;
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized String format() {
        String str = "";
        LocalDate ld = (LocalDate)this.getValue();
        if (ld != null) {
            str = ld.format(DateTimeFormatter.ofPattern(this.getInternalFormat()));
        }
        return str;
    }

    @Override
    public synchronized Object parse(String str) throws DateTimeParseException {
        LocalDate value = null;
        if (str != null && str.length() != 0) {
            value = LocalDate.parse(str, DateTimeFormatter.ofPattern(this.getInternalFormat()));
        }
        return value;
    }

    @Override
    public synchronized String getOutputText() {
        return this.getValue() != null ? ((LocalDate)this.getValue()).format(DateTimeFormatter.ofPattern(this.getOutputFormat())) : null;
    }

    private String dateToString(LocalDate date) {
        if (date != null) {
            return date.format(DateTimeFormatter.ofPattern(this.getFormat()));
        }
        return "";
    }

    private LocalDate stringToDate(String str) {
        if (str != null && !str.isEmpty()) {
            try {
                return LocalDate.parse(str, DateTimeFormatter.ofPattern(this.getFormat()));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getFormat() {
        return this.getInputMode() ? this.getInputFormat() : this.getOutputFormat();
    }

    private String getInternalFormat() {
        return CustomDate.getDatetimeInternalFormat((int)this.getDatatype());
    }
}

