/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/**
 * A notifier interface. Classes interesting in fiering an EnableEvent when the
 * setEnable method is invoked should implement this interface, and override the
 * setEnabled method to fire the event.
 * <p>
 * The reason one cannot use a regular property change listener is that the
 * property event only fires if the property is changed, but we need to be
 * notified regardles.
 */
public interface EnableNotifier {

    /**
     * Notify EnableListeners that the event has occured.
     * 
     * @param e the EnableEvent
     */
    public void fireEnableEvent(EnableEvent e);

    /**
     * Adds the specified listener to the list of listener. When an EnableEvent
     * occurs, registred listeners will be notified.
     * 
     * @param listener the EnableListener to add.
     */
    public void addEnableListener(EnableListener listener);

    /**
     * Removes the specified listener from the list of listeners that will be
     * notified when an EnableEvent occurs.
     * 
     * @param listener the EnableListener to remove
     */
    public void removeEnableListener(EnableListener listener);

    /**
     * In addition to invoking super.setEnabled, overriding methods should fire
     * the enable event.
     * 
     * @param enable the new value of the enabled property.
     * @see javax.swing.JComponent#setEnabled(boolean)
     */
    public void setEnabled(boolean enable);
    
    /**
     * @return <code>true</code> if enabled.
     * @see javax.swing.JComponent#isEnabled()
     */
    public boolean isEnabled();

}
