/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.event.ActionEvent;

/** The class responsible for holding an event */
public class G9ActionEventHolder extends G9Event {
    /** The event being stored */
    ActionEvent event;

    /**
     * Default constructor
     * @param e the event
     */
    public G9ActionEventHolder(ActionEvent e) {
        event = e;
    }

    /** 
     * Gets the event kept by this event holder.
     * @return the original ActionEvent kept by this holder.
     */
    public ActionEvent getEvent() {
        return event;
    }
}
