/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import javax.swing.event.ChangeEvent;


/** Event holder, holding a change event */
public class G9ChangeEventHolder extends G9Event {
    
    /** The change event */
    ChangeEvent event;

   /**
    * Creates a new instance.
    * @param e the change event
    */
    public G9ChangeEventHolder(ChangeEvent e) {
        event = e;
    }

    /**
     * Returns the event being stored by this event holder.
     * @return the kept event.
     */
    public ChangeEvent getEvent() {
        return event;
    }
}
