/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import javax.swing.JComboBox;


/** The dropped down event */
public class G9DroppedDownEvent extends G9Event {

    /** The combo box */
    @SuppressWarnings("rawtypes")
    private JComboBox theBox;

    /** The source */
    private Object source;

    /**
     * Returns the combo box
     * @return the box
     */
    @SuppressWarnings("rawtypes")
    public JComboBox getTheBox() {
        return theBox;
    }

    @Override
    public Object getSource() {
        return source;
    }

    /**
     * Creates a new G9DroppedDownEvent
     *
     * @param b the combo box
     * @param s the source
     */
    @SuppressWarnings("rawtypes")
    public G9DroppedDownEvent(JComboBox b, Object s) {

        theBox = b;
        source = s;
    }

}
