/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.Event;
import java.util.EventObject;

/**
 * Base class for g9 Events.
 */
public class G9Event extends G9EventHolder {
    
    /**
     * Constructs a new g9 event, with an Object as
     * source and id set to zero.
     */
    public G9Event() {
        this(new EventObject(new Object()), 0);
    }
    

    /**
     * Constructs a new g9 event, with the same source
     * as the EventObject, and id set to zero.
     * @param e the Event object
     */
    public G9Event(EventObject e) {
        this(e.getSource(), 0);
    }

    /**
     * Constructs a new g9 event, source and id is 
     * copied from the specified event
     * @param event the event to copy source and id from
     */
    public G9Event(Event event) {
        this(event.target, event.id);
    }

    /**
     * Creates a new g9 event
     * @param source the source of the event
     * @param id the id of the event
     */
    public G9Event(Object source, int id) {
        super(source, id);
    }

}
