/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.Event;
import java.awt.AWTEvent;



/**
 * Class wrapping an AWTEvent. 
*/
abstract public class G9EventHolder extends AWTEvent {
    
    /** Reference to the event held by this event holder */
    Event event;
    
    /**
     * Constructs a new G9EventHolder with the specified event.
     * @param event the event kept by this event holder
     */
    public G9EventHolder(Event event) {
        super(event);
        this.event = event;
    }
    
    /**
     * Constructs a new G9EventHolder with the specified source and id
     * @param source the source of the event
     * @param id the id of the event
     */
    public G9EventHolder(Object source, int id) {
        super(source, id);
    }
    
    
    
    
}
