/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.event.FocusEvent;


/** 
 * Class wrapping a focus event.
 */
public class G9FocusEventHolder extends G9Event {
    
    /** The focus event */
    FocusEvent event;

    /**
     * Constructs a new event holder with the specified focus event
     * 
     * @param e the focus event kept by this event holder
     */
    public G9FocusEventHolder(FocusEvent e) {
        event = e;
    }

    /**
     * Returns the event wrapped by this holder
     * 
     * @return the wrapped event.
     */
    public FocusEvent getEvent() {
        return event;
    }
}
