/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;
import java.awt.event.ItemEvent;

/** 
 * Class wrapping an Item event 
 */
public class G9ItemEventHolder extends G9Event {
    /** The wrapped event */
    ItemEvent event;
    
    /** 
     * Creates a new event holder, wrapping the specified event
     * @param e the event to wrap
     */
    public G9ItemEventHolder(ItemEvent e) {
        event = e;
    }
    
    /** 
     * Returns the wrapped event
     * @return the wrapped event
     */
    public ItemEvent getEvent() {
        return event;
    }
}
