/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;
import java.awt.event.KeyEvent;

/** Wraps a key event */
public class G9KeyEventHolder extends G9Event {
    /** The wrapped event */
    KeyEvent event;
    
    /** Flag indicating if event should be consumed */
    boolean consume = true;
    
    /** 
     * Sets the consume flag, indicating if the event should be consumed
     * @param x a boolean flag, <code>true</code> indicating that the event should be consumed.
     */
    public void setConsume(boolean x) {
        consume = x;
    }
    
    /** 
     * Returns the consume flag
     * @return a boolean 
     */
    public boolean shouldConsume() {
        return consume;
    }
    
    /** 
     * Constructs a new G9KeyEventHolder instance.
     * @param e the key event to wrap.
     */
    public G9KeyEventHolder(KeyEvent e) {
        event = e;
    }
    
    /** 
     * Returns the event wrapped by this event holder.
     * @return the wrapped key event.
     */
    public KeyEvent getEvent() {
        return event;
    }
}
