/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.util.EventListener;

/**
 * The listener interface for g9 Selected Events. Parties interessted in this event
 * should implement this interface and register as a listener on the class capable of fiering 
 * g9 selected events.
 */
public interface G9SelectionListener extends EventListener {
    
    /**
     * Inovked each time a g9 selected event occurs.
     * @param e the g9 selected event.
     */
    public void selectionChanged(G9SelectedEvent e);
    

}
