/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.AWTEvent;

/**
 * The event that is triggered signals a value changed.
 */
public class G9ValueChangedEvent extends G9Event {

    /** The id of this event. */
    public static final int VALUE_CHANGED = AWTEvent.RESERVED_ID_MAX + 1;

    private final Object oldValue;
    private final Object newValue;

    /**
     * Creates a new G9ValueChangedEvent.
     * @param source the component that has changed
     * @param id the type of evnt, e.g. VALUE_CHANGED
     * @param oldValue the old value of the component
     * @param newValue the new value of the component
     */
    public G9ValueChangedEvent(Object source, int id, Object oldValue, Object newValue) {
        super(source, id);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    /**
     * Returns the old value
     * @return the old value
     */
    public Object getOldValue() {
        return oldValue;
    }

    /**
     * Returns the new value
     * @return the new value
     */
    public Object getNewValue() {
        return newValue;
    }

    @Override
    public String paramString() {
        return "VALUE_CHANGED";
    }

}
