/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/**
 * The g9 vetoable selection event.
 */
public class G9VetoableSelectionEvent extends G9SelectedEvent {

    private boolean vetoed = false;

    /**
     * Constructs a new vetoable selection event
     * 
     * @param source the source of the event
     * @param oldSelection the current selected row
     * @param newSelection the row that will become the selected row.
     */
    public G9VetoableSelectionEvent(Object source, int oldSelection, int newSelection) {
        super(source, oldSelection, newSelection);
    }

    /**
     * Check if the selection event is vetoed.
     * 
     * @return <code>true</code> if the selection event should be vetoed.
     */
    public boolean isVetoed() {
        return vetoed;
    }

    /**
     * Vetoes the selection about to occure.
     * 
     * @param veto a boolean flag where <code>true</code> indicates that the
     *            selection is vetoed.
     */
    public void veto(boolean veto) {
        vetoed = veto;
    }

}
