/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.AWTEvent;
import java.awt.event.WindowListener;

import javax.swing.event.InternalFrameListener;

/**
 * The listener interface for receiving window and internal frame events. The
 * class that is interested in processing a g9 event implements this
 * interface, and the object created with that class is registered with a g9
 * dialog, using the dialogs's addG9EventListner method. When the g9
 * event occurs, that object' appropriate event processing method is invoked.
 */
public interface G9WindowListener extends InternalFrameListener, WindowListener {
	
	/**
     * Invoked when a dialog window is realized, and made visible.
     * 
     * @param e (missing javadoc)
     */
	public void dialogVisible(G9WindowEvent e);

    /**
     * Invoked when a dialog is created.
     * 
     * @param e (missing javadoc)
     */
    public void dialogCreated(G9WindowEvent e);

    /**
     * Invoked when a dialog is hidden.
     * 
     * @param e (missing javadoc)
     */
    public void dialogHidden(G9WindowEvent e);

    /**
     * Invoked when a dialog is opened.
     * 
     * @param e (missing javadoc)
     * @see InternalFrameListener#internalFrameOpened(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowOpened(java.awt.event.WindowEvent)
     */
    public void dialogOpened(AWTEvent e);

    /**
     * Invoked when a dialog is closing.
     * 
     * @param e (missing javadoc)
     * @see InternalFrameListener#internalFrameClosing(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowClosing(java.awt.event.WindowEvent)
     */
    public void dialogClosing(AWTEvent e);

    /**
     * Invoked when a dialog is closed.
     * 
     * @param e (missing javadoc)
     * @see InternalFrameListener#internalFrameClosed(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowClosed(java.awt.event.WindowEvent)
     */
    public void dialogClosed(AWTEvent e);

    /**
     * Invoked when a dialog is iconified.
     * 
     * @see InternalFrameListener#internalFrameIconified(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowIconified(java.awt.event.WindowEvent)
     * @param e (missing javadoc)
     */
    public void dialogIconified(AWTEvent e);

    /**
     * Invoked when a dialog is deiconified.
     * 
     * @see InternalFrameListener#internalFrameDeiconified(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowDeiconified(java.awt.event.WindowEvent)
     * @param e (missing javadoc)
     */
    public void dialogDeiconified(AWTEvent e);

    /**
     * Invoked when a dialog is activated.
     * 
     * @see InternalFrameListener#internalFrameActivated(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowActivated(java.awt.event.WindowEvent)
     * @param e (missing javadoc)
     */
    public void dialogActivated(AWTEvent e);

    /**
     * Invoked when a dialog is deactivated.
     * 
     * @see InternalFrameListener#internalFrameDeactivated(javax.swing.event.InternalFrameEvent)
     * @see WindowListener#windowDeactivated(java.awt.event.WindowEvent)
     * @param e (missing javadoc)
     */
    public void dialogDeactivated(AWTEvent e);

    

}
