/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.Component;

/** (missing javadoc) */
public abstract class CellRenderOverride {

	/** The g9 table */
	private G9Table table;
	
	/** Sets the g9 table this overrider works on.
	 * @param table the g9 table.
	 */
	void setTable(G9Table table) {
		this.table = table;
	}
	
	/**
	 * Gets the g9 table this overrider is registered on.
	 * @return the g9 table this overrider belongs to.
	 */
	public final G9Table getTable() {
		return table;
	}
	
	/**
	 * Override the renderer component. The renderer component that is passed in, is already
	 * set with default values. Override this method if you need to make special
	 * customizations to the cell, e.g. change the foreground and background color based 
	 * on the value.
	 * <p>
	 * A typical implementation of this method is:
	 * <pre>
	 * if (value.equals("some other value") {
	 * 	   renderer.setForeground(Color.MAGENTA);
	 * }
	 * return renderer;
	 * </pre>
	 * 
	 * @param renderer the default renderer component for the cell.
	 * @param line the ListblockLine that holds the data for the row.
	 * @param value the value about to be displayed in the cell
	 * @param isSelected <code>true</code> if the cell is selcted
	 * @param hasFocus <code>true</code> if the cell has focus
	 * @param row the row index
	 * @param column the column index
	 * @return the renderer used to render the value.
	 */
	public abstract Component getTableCellRendererComponent(Component renderer,
			ListblockLine line, Object value, boolean isSelected, boolean hasFocus, int row,
			int column);
		

	
	
}
