/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.io.File;
import java.net.URL;

import no.esito.util.ServiceLoader;

/**
 * The File Launcher is responsible for delegating the file actions to an
 * implementation of the Launcher interface. The delegate is either configured
 * using a property file (typically <code>g9.config.properties</code> ) or a
 * Spring Configuration. See the Java Target manual in the g9 documentation
 * for more information about how to configure the runtime system.
 *
 * <p>
 * <em>Note:</em> Previous versions of this class delegated to a LauncherInterface. These methods are now
 * deprecated and the LaunchInterface has been replaced by {@link Launcher}.
 *
 */
public class FileLauncher {

    /**
     * The default implementation for the LauncherInterface interface
     *
     * @deprecated The default file launcher is now defined as a spring bean in
     *             the the no.g9.support.G9Services.xml.
     */
    @Deprecated
    public static final String DEFAULT_FILELAUNCHER_IMPL = "no.g9.client.support.JDICLauncher";

    private static Launcher delegate = ServiceLoader.getService(Launcher.class);

    /**
     * Launches the associated application to open the given file.
     *
     * @param file
     *            the given file.
     * @roseuid 437DEA5E0231
     * @deprecated This method is replaced by {@link #open(File)}.
     */
    @Deprecated
    public static void openLocal(File file) {
        open(file);
    }

    /**
     * Launches the system default browser to show the given URL.
     *
     * @param url
     *            the given URL.
     * @roseuid 437DEA5E023A
     * @deprecated This method is replaced by {@link #open(URL)}.
     */
    @Deprecated
    public static void openRemote(URL url) {
        open(url);
    }

    /**
     * Launch the associated application to open the given file.
     * @param file the file to open.
     */
    public static void open(File file) {
        delegate.open(file);
    }

    /**
     * Launch the system default browser to display the given URL.
     * @param url the URL to browse.
     */
    public static void open(URL url) {
        delegate.open(url);
    }

}
