/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.Toolkit;

/**
 * Utility class used for scaling fonts from 72 dpi to 120 dpi
 *
 */
public class FontTools {
    
    /**
     * Converts a Windows font size to a 72 dpi (assumed by Java 2D) font
     * size. Java 2D API assumes 72 dpi screen resolution. Windows uses 96
     * or 120 dpi depending on the font size setting in the display
     * properties. This method calculetes the 72 dpi font size relative to
     * the dpi setting in Windows and the input value.
     * 
     * @param size font size 
     * @return 72 dpi font size
     * 
     */
    public static int calcFontSize(int size) {
    	String os = System.getProperty("os.name");
    	if (os != null && os.startsWith("Windows")) {
    		int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
    		return (int) Math.round((size * screenRes) / 72.0);
    	}
    	return size;
    }

}
